% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_legend.R
\name{tm_legend}
\alias{tm_legend}
\alias{tm_legend_hide}
\alias{tm_legend_combine}
\alias{tm_legend_bivariate}
\title{Legend}
\usage{
tm_legend(
  title,
  show,
  orientation,
  design,
  reverse,
  na.show,
  position,
  group_id,
  width,
  height,
  z,
  title.color,
  title.size,
  title.fontface,
  title.fontfamily,
  title.alpha,
  title.padding,
  title.align,
  text.color,
  text.size,
  text.fontface,
  text.fontfamily,
  text.alpha,
  format,
  frame,
  frame.lwd,
  frame.r,
  bg,
  bg.color,
  bg.alpha,
  absolute_fontsize,
  item.height,
  item.width,
  item.space,
  item.na.height,
  item.na.width,
  item.na.space,
  item.shape,
  ticks,
  ticks.disable.na,
  ticks.col,
  ticks.lwd,
  margins,
  item_text.margin,
  ...
)

tm_legend_hide()

tm_legend_combine(variable)

tm_legend_bivariate(
  xlab,
  ylab,
  xlab.color,
  xlab.size,
  xlab.fontface,
  xlab.fontfamily,
  xlab.alpha,
  xlab.padding,
  xlab.align,
  ylab.color,
  ylab.size,
  ylab.fontface,
  ylab.fontfamily,
  ylab.alpha,
  ylab.padding,
  ylab.align,
  ...
)
}
\arguments{
\item{title}{Legend title}

\item{show}{Show legend?}

\item{orientation}{Orientation of the legend: \code{"portrait"} or \code{"landscape"}}

\item{design}{Legend design \code{"standard"}. No other designs implemented yet.}

\item{reverse}{Should the legend be reversed?}

\item{na.show}{Show \code{NA} values in legend?}

\item{position}{The position specification of the component: an object created with \code{tm_pos_in()} or \code{tm_pos_out()}. Or, as a shortcut, a vector of two values, specifying the x and y coordinates. The first is \code{"left"}, \code{"center"} or \code{"right"} (or upper case, meaning tighter to the map frame), the second \code{"top"}, \code{"center"} or \code{"bottom"}. Numeric values are also supported, where 0, 0 means left bottom and 1, 1 right top. See also \href{https://r-tmap.github.io/tmap/articles/adv_positions}{vignette about positioning}. In case multiple components should be combined (stacked), use \code{group_id} and specify \code{component} in \code{\link[=tm_comp_group]{tm_comp_group()}}.}

\item{group_id}{Component group id name. All components (e.g. legends, titles, etc) with the same \code{group_id} will be grouped. The specifications of how they are placed (e.g. stacking, margins etc.) are determined in \code{\link[=tm_comp_group]{tm_comp_group()}} where its argument \code{id} should correspond to \code{group_id}.}

\item{width}{Width of the legend. Units are 'text line heights'. In case a negative number is specified, the units are (approximate) pixels. The relation between these two is configured via the option \code{absolute_fontsize}.}

\item{height}{Height of the legend. Units are 'text line heights'. In case a negative number is specified, the units are (approximate) pixels. The relation between these two is configured via the option \code{absolute_fontsize}.}

\item{z}{z index, e.g. the place of the component relative to the other componets}

\item{title.color}{The color of the title of the legend.}

\item{title.size}{The size of the title of the legend.}

\item{title.fontface}{The font face of the title of the legend. See \code{graphics::par}, option 'font'.}

\item{title.fontfamily}{The font family of the title of the legend. See \code{graphics::par}, option 'family'.}

\item{title.alpha}{The alpha transparency of the title of the legend.}

\item{title.padding}{The padding of the title of the legend. A vector of 4 values: bottom, left, top, right. The unit is the device height (for bottom and top) or width (for left and right).}

\item{title.align}{The align of the title of the legend.}

\item{text.color}{The color of the text of the legend.}

\item{text.size}{The size of the text of the legend.}

\item{text.fontface}{The font face of the text of the legend. See \code{graphics::par}, option 'font'.}

\item{text.fontfamily}{The font family of the text of the legend. See \code{graphics::par}, option 'family'.}

\item{text.alpha}{The alpha transparency of the text of the legend.}

\item{format}{Not used anymore: use the format argument of the \verb{tm_scale_*()} functions instead.}

\item{frame}{frame should a frame be drawn?}

\item{frame.lwd}{frame line width}

\item{frame.r}{Radius of the rounded frame corners. 0 means no rounding.}

\item{bg}{Show background?}

\item{bg.color}{The color of the bg of the legend.}

\item{bg.alpha}{The alpha transparency of the bg of the legend.}

\item{absolute_fontsize}{The absolute fontsize of the legend. So far, only used to calculate legend dimensions}

\item{item.height}{The height of the item of the legend.}

\item{item.width}{The width of the item of the legend.}

\item{item.space}{The space of the item of the legend. In terms of number of text line heights.}

\item{item.na.height}{The height of the na item of the legend.}

\item{item.na.width}{The width of the na item of the legend.}

\item{item.na.space}{The space of the na item of the legend. In terms of number of text line heights.}

\item{item.shape}{The shape of the item of the legend.}

\item{ticks}{List of vectors of size 2 that determines the horizontal tick mark lines (for portrait legends). The values are the y-values of begin and endpoint of each tick mark.}

\item{ticks.disable.na}{Remove ticks for \code{NA} values}

\item{ticks.col}{The color of the ticks of the legend.}

\item{ticks.lwd}{The line width of the ticks of the legend. See \code{graphics::par}, option 'lwd'.}

\item{margins}{The margins of the legend. A vector of 4 values: bottom, left, top, right. The unit is the device height (for bottom and top) or width (for left and right).}

\item{item_text.margin}{The margin of the space between item and text of the legend.}

\item{...}{visual values, e.g. \code{col}, \code{fill}, \code{lwd}, can be specified. If so, they overrule the default visual values, which are determined by the drawn map objects (e.g. polygons)}

\item{variable}{visual (or transformation) variable to combine the legend with: e.g. \code{"fill"} or \code{"size"}}

\item{xlab}{label for the x dimension (rows)}

\item{ylab}{label for the y dimension (columns)}

\item{xlab.color}{The color of the xlab of the legend.}

\item{xlab.size}{The size of the xlab of the legend.}

\item{xlab.fontface}{The font face of the xlab of the legend. See \code{graphics::par}, option 'font'.}

\item{xlab.fontfamily}{The font family of the xlab of the legend. See \code{graphics::par}, option 'family'.}

\item{xlab.alpha}{The alpha transparency of the xlab of the legend.}

\item{xlab.padding}{The padding of the xlab of the legend. A vector of 4 values: bottom, left, top, right. The unit is the device height (for bottom and top) or width (for left and right).}

\item{xlab.align}{The align of the xlab of the legend.}

\item{ylab.color}{The color of the ylab of the legend.}

\item{ylab.size}{The size of the ylab of the legend.}

\item{ylab.fontface}{The font face of the ylab of the legend. See \code{graphics::par}, option 'font'.}

\item{ylab.fontfamily}{The font family of the ylab of the legend. See \code{graphics::par}, option 'family'.}

\item{ylab.alpha}{The alpha transparency of the ylab of the legend.}

\item{ylab.padding}{The padding of the ylab of the legend. A vector of 4 values: bottom, left, top, right. The unit is the device height (for bottom and top) or width (for left and right).}

\item{ylab.align}{The align of the ylab of the legend.}
}
\value{
A tm_legend component
}
\description{
Legend specification
}
\examples{
# Example using different settings from tm_legend()

tm_shape(World) +
  tm_polygons(
    fill = "HPI",
    fill.legend = tm_legend(
      title = "Home Price Index",
      design = "standard",
      title.color = "orange",
      bg.color = "purple",
      show = TRUE
	),
    id = "name",
    # Format the labels using dollar sign
    fill.scale = tm_scale_intervals(
      label.format = function(x) format(x, big.mark = " ")),
)
}
\seealso{
\href{https://r-tmap.github.io/tmap/articles/basics_legends}{Vignette about legends}
}
