% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_components.R
\name{tm_scalebar}
\alias{tm_scalebar}
\title{Map component: scale bar}
\usage{
tm_scalebar(
  breaks,
  width,
  text.size,
  text.color,
  color.dark,
  color.light,
  lwd,
  position,
  bg.color,
  bg.alpha,
  size = "deprecated",
  stack,
  frame,
  frame.lwd,
  frame.r,
  margins,
  z
)
}
\arguments{
\item{breaks}{breaks}

\item{width}{width of the scale bar. Units are number of text line heights, which is similar to the number of characters.}

\item{text.size}{text size}

\item{text.color}{text.color}

\item{color.dark}{color.dark}

\item{color.light}{color.light}

\item{lwd}{linewidth}

\item{position}{An object created with \code{tm_pos_in()} or \code{tm_pos_out()}. Or, as a shortcut, a vector of two values, specifying the x and y coordinates. The first is \code{"left"}, \code{"center"} or \code{"right"} (or upper case, meaning tighter to the map frame), the second \code{"top"}, \code{"center"} or \code{"bottom"}. Numeric values are also supported, where 0, 0 means left bottom and 1, 1 right top. See also \href{https://r-tmap.github.io/tmap/articles/adv_positions}{vignette about positioning}.}

\item{bg.color}{Background color}

\item{bg.alpha}{Background transparency}

\item{size}{Deprecated (use \code{text.size} instead)}

\item{stack}{stack with other map components, either \code{"vertical"} or \code{"horizontal"}.}

\item{frame}{frame}

\item{frame.lwd}{frame line width}

\item{frame.r}{Radius of the rounded frame corners. 0 means no rounding.}

\item{margins}{margins}

\item{z}{z}
}
\description{
Map component that adds a scale bar.
}
\seealso{
\href{https://r-tmap.github.io/tmap/articles/basics_components}{Vignette about components}
}
