% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocode_OSM.R
\name{geocode_OSM}
\alias{geocode_OSM}
\title{Geocodes a location using OpenStreetMap Nominatim}
\usage{
geocode_OSM(q, projection = "longlat")
}
\arguments{
\item{q}{a character that specifies a search query. For instance \code{"India"} or \code{"CBS Weg 11, Heerlen, Netherlands"}.}

\item{projection}{projection in which the coordinates and bounding box are returned. Either a \code{PROJ.4} character string or a shortcut. See \code{\link{get_proj4}} for a list of shortcut values.}
}
\value{
A list of two items: \code{"coords"}, a vector containing the longitude and latitude coordinates, and \code{"bbox"}, the corresponding bounding box.
}
\description{
Geocodes a location (based on a search query) to coordinates and a bounding box. Similar to geocode from the ggmap package. It uses OpenStreetMap Nominatim.
}
\examples{
geocode_OSM("India")

geocode_OSM("CBS Weg 1, Heerlen")

geocode_OSM("CBS Weg 1, Heerlen", projection = "rd")
}
\seealso{
\code{\link{bb}}
}

