% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/append_data.R
\name{append_data}
\alias{append_data}
\title{Append data to a shape object}
\usage{
append_data(shp, data, key.shp = NULL, key.data = NULL,
  ignore.duplicates = FALSE, ignore.na = FALSE,
  fixed.order = is.null(key.data) && is.null(key.shp))
}
\arguments{
\item{shp}{shape object, which is one of
\enumerate{
 \item{\code{\link[sp:SpatialPolygonsDataFrame]{SpatialPolygons(DataFrame)}}}
 \item{\code{\link[sp:SpatialPointsDataFrame]{SpatialPoints(DataFrame)}}}
 \item{\code{\link[sp:SpatialLinesDataFrame]{SpatialLines(DataFrame)}}}
 \item{\code{\link[sp:SpatialGridDataFrame]{SpatialGrid(DataFrame)}}}
 \item{\code{\link[sp:SpatialPixelsDataFrame]{SpatialPixels(DataFrame)}}}
}}

\item{data}{data.frame}

\item{key.shp}{variable name of \code{shp} map data to be matched with \code{key.data}. If not specified, and \code{fixed.order} is \code{FALSE}, the ID's of the polygons/lines/points are taken.}

\item{key.data}{variable name of \code{data} to be matched with \code{key.shp}. If not specified, and \code{fixed.order} is \code{FALSE}, the row names of \code{data} are taken.}

\item{ignore.duplicates}{should duplicated keys in \code{data} be ignored? (\code{FALSE} by default)}

\item{ignore.na}{should NA values in \code{key.data} and \code{key.shp} be ignored? (\code{FALSE} by default)}

\item{fixed.order}{should the data be append in the same order as the shapes in \code{shp}?}
}
\value{
Shape object with appended data.
}
\description{
Data, in the format of a data.frame, is appended to a shape object. This is either done by a right join where keys are specified for both data and shape, or by fixed order.
}
\examples{
\dontrun{
data(Europe)

f <- tempfile()
download.file("http://kejser.org/wp-content/uploads/2014/06/Country.csv", destfile = f)
domain_codes <- read.table(f, header=TRUE, sep="|")
unlink(f)

domain_codes <- subset(domain_codes, select = c("Alpha3Code", "TopLevelDomain"))
domain_codes$Alpha3Code <- toupper(domain_codes$Alpha3Code)

Europe <- append_data(Europe, domain_codes, key.shp = "iso_a3", key.data = "Alpha3Code",
    ignore.na = TRUE)

qtm(Europe, text="TopLevelDomain")
}
}

