% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/02_method_04_kRp.corpus-class_read.corp.custom.R
\docType{methods}
\name{read.corp.custom,kRp.corpus-method}
\alias{read.corp.custom,kRp.corpus-method}
\title{Apply read.corp.custom() to all texts in kRp.corpus objects}
\usage{
\S4method{read.corp.custom}{kRp.corpus}(corpus, caseSens = TRUE, log.base = 10,
      keep_dtm = FALSE, ...)
}
\arguments{
\item{corpus}{An object of class \code{\link[tm.plugin.koRpus:kRp.corpus-class]{kRp.corpus}}.}

\item{caseSens}{Logical. If \code{FALSE},
      all tokens will be matched in their lower case form.}

\item{log.base}{A numeric value defining the base of the logarithm used for inverse document frequency (idf). See
\code{\link[base:log]{log}} for details.}

\item{keep_dtm}{Logical. If \code{TRUE} and \code{corpus} does not yet provide a
\code{\link[koRpus:docTermMatrix]{document term matrix}},
      the one generated during calculation
will be added to the resulting object.}

\item{...}{Options to pass through to the \code{\link[koRpus:read.corp.custom]{read.corp.custom}} method
for objects of the class union \code{\link[koRpus:kRp.text-class]{kRp.text}}.}
}
\value{
An object of the same class as \code{corpus}.
}
\description{
This method calls \code{\link[koRpus:read.corp.custom]{read.corp.custom}} on all tagged text objects
inside the given \code{corpus} object.
}
\details{
Since the analysis is based on a document term matrix,
      a pre-existing matrix as a feature of the \code{corpus} object 
will be used if it matches the case sensitivity setting. Otherwise a new matrix will be generated (but not replace the
existing one). If no document term matrix is present yet,
      also one will be generated and can be kept as an additional feature
of the resulting object.
}
\examples{
# use readCorpus() to create an object of class kRp.corpus
# code is only run when the english language package can be loaded
if(require("koRpus.lang.en", quietly = TRUE)){
  myCorpus <- readCorpus(
    dir=file.path(
      path.package("tm.plugin.koRpus"), "examples", "corpus", "Edwards"
    ),
    hierarchy=list(
      Source=c(
        Wikipedia_prev="Wikipedia (old)",
        Wikipedia_new="Wikipedia (new)"
      )
    ),
    # use tokenize() so examples run without a TreeTagger installation
    tagger="tokenize",
    lang="en"
  )

  myCorpus <- read.corp.custom(myCorpus)
  corpusCorpFreq(myCorpus)
} else {}
}
