% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tip.R
\name{tip}
\alias{tip}
\alias{tip_with_continuous}
\alias{tip_c}
\title{Tip a result with a normally distributed confounder.}
\usage{
tip(
  effect,
  smd = NULL,
  outcome_association = NULL,
  verbose = TRUE,
  correction_factor = "none"
)

tip_with_continuous(
  effect,
  smd = NULL,
  outcome_association = NULL,
  verbose = TRUE,
  correction_factor = "none"
)

tip_c(
  effect,
  smd = NULL,
  outcome_association = NULL,
  verbose = TRUE,
  correction_factor = "none"
)
}
\arguments{
\item{effect}{Numeric positive value. Observed exposure - outcome effect
(assumed to be the exponentiated coefficient, so a relative risk, odds
ratio, or hazard ratio). This can be the point estimate, lower confidence
bound, or upper confidence bound.}

\item{smd}{Numeric. Estimated difference in scaled means between the
unmeasured confounder in the exposed population and unexposed population}

\item{outcome_association}{Numeric positive value. Estimated association
between the unmeasured confounder and the outcome}

\item{verbose}{Logical. Indicates whether to print informative message.
Default: \code{TRUE}}

\item{correction_factor}{Character string. Options are "none", "hr", "or".
For common outcomes (>15\%), the odds ratio or hazard ratio is not a good
estimate for the relative risk. In these cases, we can apply a correction
factor. If you are supplying a hazard ratio for a common outcome, set
this to "hr"; if you are supplying an odds ratio for a common outcome, set
this to "or"; if you are supplying a risk ratio or your outcome is rare,
set this to "none" (default).}
}
\value{
Data frame.
}
\description{
choose one of the following, and the other will be estimated:
\itemize{
\item \code{smd}
\item \code{outcome_association}
}
}
\examples{
## to estimate the association between an unmeasured confounder and outcome
## needed to tip analysis
tip(1.2, smd = -2)

## to estimate the number of unmeasured confounders specified needed to tip
## the analysis
tip(1.2, smd = -2, outcome_association = .99)

## Example with broom
if (requireNamespace("broom", quietly = TRUE) &&
    requireNamespace("dplyr", quietly = TRUE)) {
  glm(am ~ mpg, data = mtcars, family = "binomial") \%>\%
   broom::tidy(conf.int = TRUE, exponentiate = TRUE) \%>\%
   dplyr::filter(term == "mpg") \%>\%
   dplyr::pull(conf.low) \%>\%
   tip(outcome_association = 2.5)
}
}
