% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tip.R
\name{tip_with_binary}
\alias{tip_with_binary}
\alias{tip_b}
\title{Tip a result with a binary confounder.}
\usage{
tip_with_binary(
  d,
  exposed_p = NULL,
  unexposed_p = NULL,
  outcome_association = NULL,
  verbose = TRUE,
  lb_name = "conf.low",
  ub_name = "conf.high"
)

tip_b(
  d,
  exposed_p = NULL,
  unexposed_p = NULL,
  outcome_association = NULL,
  verbose = TRUE,
  lb_name = "conf.low",
  ub_name = "conf.high"
)
}
\arguments{
\item{d}{Data frame. A data frame with the observed effect(s). This should have
at least two columns with the lower and upper confidence bounds. These
columns are assumed to be called \code{conf.low} and \code{conf.high}. If this
is not the case, the names can be changed using the \code{lb_name} and
\code{ub_name} parameters.}

\item{exposed_p}{Numeric between 0 and 1. Estimated prevalence of the
unmeasured confounder in the exposed population}

\item{unexposed_p}{Numeric between 0 and 1. Estimated prevalence of the
unmeasured confounder in the unexposed population}

\item{outcome_association}{Numeric positive value. estimated association
between the unmeasured confounder and the outcome}

\item{verbose}{Logical. Indicates whether to print informative message.
Default: \code{TRUE}}

\item{lb_name}{Character. Column name of \code{d} that holds the lower
confidence bound. Default: \code{conf.low} based on \code{broom} defaults.}

\item{ub_name}{Character. Column name of \code{d} that holds the upper
confidence bound. Default: \code{conf.high} based on \code{broom} defaults.}
}
\description{
Choose two of the following three to specify, and the third will be estimated:
\itemize{
\item \code{exposed_p}
\item \code{unexposed_p}
\item \code{outcome_association}
}

Alternatively, specify all three and the function will return the number of unmeasured
confounders specified needed to tip the analysis.
}
\details{
\code{\link[=tip_b]{tip_b()}} is an alias for \code{\link[=tip_with_binary]{tip_with_binary()}}.
}
\examples{
d <- data.frame(conf.low = 1.2, conf.high = 1.5)
## to estimate the association between an unmeasured confounder and outcome
## needed to tip analysis
tip_with_binary(d, exposed_p = 0.5, unexposed_p = 0)

## to estimate the number of unmeasured confounders specified needed to tip
## the analysis
tip_with_binary(d, exposed_p = 0.5, unexposed_p = 0, outcome_association = 1.1)

## Example with broom
if (requireNamespace("broom", quietly = TRUE) &&
    requireNamespace("dplyr", quietly = TRUE)) {
  glm(am ~ mpg, data = mtcars, family = "binomial") \%>\%
   broom::tidy(conf.int = TRUE, exponentiate = TRUE) \%>\%
   dplyr::filter(term == "mpg") \%>\%
   tip_with_binary(exposed_p = 1, outcome_association = 1.15)
}
}
