% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_stochast_weight_posterior.R
\name{get_stochast_weight_posterior}
\alias{get_stochast_weight_posterior}
\title{Average over posteriors created using weights randomly drawn from a distribution of weights}
\usage{
get_stochast_weight_posterior(
  map_prior,
  new_trial_dat,
  weights,
  null_effect = 0,
  sigma,
  mc_error_margin = 0.05
)
}
\arguments{
\item{map_prior}{The MAP prior to be robustified, created using \code{RBesT::automixfit()}.}

\item{new_trial_dat}{A vector summarising the new trial data. See \code{createNewTrialData()}.}

\item{weights}{A vector containing the weights to be assigned to the informative component.}

\item{null_effect}{The null treatment effect. Defaults to 0.}

\item{sigma}{Unit information standard deviation used by \code{RBesT::robustify()}.}

\item{mc_error_margin}{Monte Carlo error margin. Defaults to 0.05.}
}
\value{
List object containing averaged estimates of posterior quantiles (obtained with different weights) and data on Monte Carlo error.
}
\description{
Runs Monte Carlo simulations with different weights on the informative component of the MAP prior and averages over them.
Weights may be drawn randomly from the pooled distribution of expert-weightings obtained in an expert elicitation exercise.
}
\examples{

new_trial_dat <- create_new_trial_data(
   n_total = 30,
   est = 1.27,
   se = 0.95
   )
expert_weights <- rbind(
  c(0, 0, 0, 0, 2, 3, 3, 2, 0, 0),
  c(0, 0, 0, 1, 2, 4, 2, 1, 0, 0),
  c(0, 0, 0, 1, 2, 3, 2, 2, 0, 0)
  )
set.seed(123)
get_stochast_weight_posterior(
  map_prior = load_tipmap_data("tipmapPrior.rds"),
  new_trial_dat = new_trial_dat,
  weights = draw_beta_mixture_nsamples(expert_weights, n = 100),
  sigma = 12
)

}
\seealso{
\code{\link{create_new_trial_data}}, \code{\link{draw_beta_mixture_nsamples}}.
}
