% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tinytest.R
\name{run_test_dir}
\alias{run_test_dir}
\alias{test_all}
\title{Run all tests in a directory}
\usage{
run_test_dir(dir = "inst/tinytest", pattern = "^test.*\\\\.[rR]",
  at_home = TRUE, verbose = getOption("tt.verbose", TRUE),
  color = getOption("tt.pr.color", TRUE))

test_all(pkgdir = "./", testdir = "inst/tinytest", ...)
}
\arguments{
\item{dir}{\code{[character]} path to directory}

\item{pattern}{\code{[character]} A regular expression that is used to find
scripts in \code{dir} containing tests (by default \code{.R} or \code{.r}
files starting with \code{test}).}

\item{at_home}{\code{[logical]} toggle local tests.}

\item{verbose}{\code{[logical]} toggle verbosity during execution}

\item{color}{\code{[logical]} toggle colorize output}

\item{pkgdir}{\code{[character]} scalar. Root directory of the package (i.e. 
direcory where \code{DESCRIPTION} and \code{NAMESPACE} reside).}

\item{testdir}{\code{[character]} scalar. Subdirectory where test files are
stored.}

\item{...}{passed to \code{run_test_dir}.}
}
\value{
A \code{tinytests} object
}
\description{
\code{run\_test\_dir} runs all test files in a directory.

\code{test_all} is a convenience function for package development, that wraps
\code{run_test_dir}. By default, it runs all files starting with
\code{test} in \code{./inst/tinytest/}.  It is assumed that all functions to be
tested are loaded.
}
\examples{
# create a test file in tempdir
tests <- "
addOne <- function(x) x + 2

expect_true(addOne(0) > 0)
expect_equal(2, addOne(1))
"
testfile <- tempfile(pattern="test_", fileext=".R")
write(tests, testfile)

# extract testdir
testdir <- dirname(testfile)
# run all files starting with 'test' in testdir
out <- run_test_dir(testdir)
print(out)
dat <- as.data.frame(out)

}
\seealso{
Other test-files: \code{\link{build_install_test}},
  \code{\link{run_test_file}},
  \code{\link{summary.tinytests}},
  \code{\link{test_package}}
}
\concept{test-files}
