% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tt.R, R/zzz-aliases.R
\name{plot_tt}
\alias{plot_tt}
\alias{tt_plot}
\title{Insert images and inline plots into tinytable objects}
\usage{
plot_tt(
  x,
  i = NULL,
  j = NULL,
  fun = NULL,
  data = NULL,
  color = "black",
  xlim = NULL,
  height = 1,
  height_plot = 400,
  width_plot = 1200,
  images = NULL,
  sprintf = "\%s",
  assets = "tinytable_assets",
  ...
)

tt_plot(
  x,
  i = NULL,
  j = NULL,
  fun = NULL,
  data = NULL,
  color = "black",
  xlim = NULL,
  height = 1,
  height_plot = 400,
  width_plot = 1200,
  images = NULL,
  sprintf = "\%s",
  assets = "tinytable_assets",
  ...
)
}
\arguments{
\item{x}{A tinytable object.}

\item{i}{Integer vector, the row indices where images are to be inserted. If \code{NULL},
images will be inserted in all rows.}

\item{j}{Integer vector, the column indices where images are to be inserted. If \code{NULL},
images will be inserted in all columns.}

\item{fun}{String or function to generate inline plots.
\itemize{
\item Built-in plot types (strings):
\itemize{
\item \code{"histogram"}: Creates histograms from numeric vectors. Accepts \code{color} argument.
\item \code{"density"}: Creates density plots from numeric vectors. Accepts \code{color} argument.
\item \code{"bar"}: Creates horizontal bar charts from single numeric values. Accepts \code{color} (single value, or length-2 vector for bar and background colors in static formats) and \code{xlim} arguments.
\item \code{"line"}: Creates line plots from data frames with \code{x} and \code{y} columns. Accepts \code{color} and \code{xlim} arguments.
}
\item Custom functions:
\itemize{
\item Functions that return \code{ggplot2} objects.
\item Functions that return another function which generates a base \code{R} plot, ex: \code{function(x) {function() hist(x)}}
\item Note: When using custom ggplot2 functions that return plots with text elements, the text size will normally need to be adjusted because the plot is inserted as a very small image in the table. Text sizes of 1 or smaller often work well (e.g., \code{theme(text = element_text(size = 1))}).
}
\item See the tutorial on the \code{tinytable} website for more information.
}}

\item{data}{a list of data frames or vectors to be used by the plotting functions in \code{fun}.}

\item{color}{string Name of color to use for inline plots (passed to the \code{col} argument base \code{graphics} plots in \code{R}). For bar plots in static output formats (PNG, PDF, etc.), can be a vector of length 2: c(bar_color, background_color) to show progress against a maximum. Note: Tabulator format only uses the first color.}

\item{xlim}{Numeric vector of length 2. Controls the range of bar plots.}

\item{height}{Numeric, the height of the images in the table in em units.}

\item{height_plot}{Numeric, the height of generated plot images in pixels (default: 400).}

\item{width_plot}{Numeric, the width of generated plot images in pixels (default: 1200).}

\item{images}{Character vector, the paths to the images to be inserted. Paths are relative to the main table file or Quarto (Rmarkdown) document.}

\item{sprintf}{Character string, a sprintf format string to format the generated cell content. Default is "\%s" which displays the content as-is. Use this to wrap images or plots in custom markup.}

\item{assets}{Path to the directory where generated assets are stored. This path is relative to the location where a table is saved.}

\item{...}{Extra arguments are passed to the function in \code{fun}. Important: Custom plotting functions must always have \code{...} as an argument.}
}
\value{
A modified tinytable object with images or plots inserted.
}
\description{
The \code{plot_tt()} function allows for the insertion of images and inline plots into
tinytable objects. This function can handle both local and web-based images.
}
\details{
The \code{plot_tt()} can insert images and inline plots into tables.
}
\examples{
\dontrun{
# Bar plots with single and dual colors
dat <- data.frame(
  Metric = c("Sales", "Conversion", "Growth", "Efficiency"),
  Value = c(75, 45, 92, 38),
  Percentage = c(0.75, 0.45, 0.92, 0.38)
)

tt(dat) |>
  plot_tt(j = 2, fun = "bar", data = as.list(dat$Value), color = "darkorange") |>
  plot_tt(j = 3, fun = "bar", data = as.list(dat$Percentage),
          color = c("steelblue", "lightgrey"), xlim = c(0, 1))

# Built-in plot types
plot_data <- list(mtcars$mpg, mtcars$hp, mtcars$qsec)

dat <- data.frame(
  Variables = c("mpg", "hp", "qsec"),
  Histogram = "",
  Density = "",
  Line = ""
)

# Random data for sparklines
lines <- lapply(1:3, \(x) data.frame(x = 1:10, y = rnorm(10)))

tt(dat) |>
  plot_tt(j = 2, fun = "histogram", data = plot_data) |>
  plot_tt(j = 3, fun = "density", data = plot_data, color = "darkgreen") |>
  plot_tt(j = 4, fun = "line", data = lines, color = "blue") |>
  style_tt(j = 2:4, align = "c")

# Custom function example (must have ... argument)
custom_hist <- function(d, ...) {
  function() hist(d, axes = FALSE, ann = FALSE, col = "lightblue")
}

tt(data.frame(Variables = "mpg", Histogram = "")) |>
  plot_tt(j = 2, fun = custom_hist, data = list(mtcars$mpg))
}

}
