% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_tt.R
\name{group_tt}
\alias{group_tt}
\title{Spanning labels to identify groups of rows or columns}
\usage{
group_tt(x, i = NULL, j = NULL, indent = 1, ...)
}
\arguments{
\item{x}{A data frame or data table to be rendered as a table.}

\item{i}{A named list of row indices to group. The names of the list will be used as labels.}

\item{j}{A named list of column indices to group. The names of the list will be used as labels. See examples below. Note: empty labels must be a space: " ".}

\item{indent}{integer number of \code{pt} to use when indenting the non-labelled rows.}

\item{...}{Other arguments are ignored.}
}
\value{
An object of class \code{tt} representing the table.
}
\description{
Spanning labels to identify groups of rows or columns
}
\details{
Warning: The \code{style_tt()} can normally be used to style the group headers, as expected, but that feature is not available for Markdown and Word tables.
}
\examples{

tt(mtcars[1:10, 1:5]) |>
  group_tt(
    i = list(
      "Hello" = 3,
      "World" = 8),
    j = list(
      "Foo" = 2:3,
      "Bar" = 4:5))
}
