% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inplace.R
\name{inplace}
\alias{inplace}
\alias{\%:=\%}
\title{General In-place Modifier Operator}
\usage{
x \%:=\% f
}
\arguments{
\item{x}{a variable.}

\item{f}{a (possibly anonymous) function to be applied in-place on \code{x}.
The function must take one argument only.}
}
\value{
This operator does not return any value: \cr
It is an in-place modifier, and thus modifies the object directly. \cr \cr
}
\description{
The \code{x \%:=\% f} operator performs
in-place modification of some object \code{x}
with a function \code{f}. \cr
\cr
For example this:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{mtcars$mpg[mtcars$cyl > 6] <- mtcars$mpg[mtcars$cyl>6]^2
}\if{html}{\out{</div>}}

Can now be re-written as:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{mtcars$mpg[mtcars$cyl > 6] \%:=\% \\(x) x^2
}\if{html}{\out{</div>}}
}
\examples{
set.seed(1)
object <- matrix(rpois(10, 10), ncol = 2)
print(object)
y <- 3
object \%:=\% \(x) x + y # same as object <- object + y
print(object)

}
\seealso{
\link{tinycodet_dry}
}
