% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_multi_deg_all.R
\name{multi_deg_all}
\alias{multi_deg_all}
\title{multi_deg_all}
\usage{
multi_deg_all(
  exp,
  group_list,
  ids,
  pkg = 4,
  symmetry = TRUE,
  my_genes = NULL,
  show_rownames = FALSE,
  cluster_cols = TRUE,
  color_volcano = c("#2874C5", "grey", "#f87669"),
  ...
)
}
\arguments{
\item{exp}{A numeric matrix}

\item{group_list}{A factor with duplicated character or factor}

\item{ids}{a data.frame with 2 columns,including probe_id and symbol}

\item{pkg}{a integer ,means which Differential analysis packages you used,we support three packages by now, 1,2,3,4 respectively means "DESeq2","edgeR","limma(voom)","limma"}

\item{symmetry}{a logical value ,would you like to get your plot symmetrical}

\item{my_genes}{genes for pheatmap}

\item{show_rownames}{boolean specifying if column names are be shown.}

\item{cluster_cols}{boolean values determining if columns should be clustered or \code{hclust} object.}

\item{color_volcano}{color for volcano}

\item{...}{other parameters from multi_deg}
}
\value{
a list with deg data.frame, volcano plot and a list with DEGs.
}
\description{
do diffiencial analysis according to exprission set and group information
}
\examples{
\donttest{
gse = "GSE474"
geo = geo_download(gse,destdir=tempdir())
geo$exp[1:4,1:4]
geo$exp=log2(geo$exp+1)
group_list=ifelse(stringr::str_detect(geo$pd$title,"MObese"),"MObese",
ifelse(stringr::str_detect(geo$pd$title,"NonObese"),"NonObese","Obese"))
group_list=factor(group_list,levels = c("NonObese","Obese","MObese"))
find_anno(geo$gpl)
ids = AnnoProbe::idmap(geo$gpl,destdir = tempdir())
dcp = multi_deg_all(geo$exp,
group_list,ids,adjust = FALSE)
dcp[[3]]
}
}
\seealso{
\code{\link{geo_download}};\code{\link{draw_volcano}};\code{\link{draw_venn}}
}
\author{
Xiaojie Sun
}
