% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timsr.R
\name{query}
\alias{query}
\title{Query for raw data.}
\usage{
query(timsr, frames, columns = all_columns)
}
\arguments{
\item{timsr}{Instance of TimsR.}

\item{frames}{Vector of frame numbers to extract.}

\item{columns}{Vector of columns to extract. Defaults to all columns.}
}
\value{
data.frame with selected columns.
}
\description{
Get the raw data from Bruker's 'tdf_bin' format.
Defaults to both raw data ('frame','scan','tof','intensity') and its tranformations into physical units ('mz','inv_ion_mobility','retention_time').
}
\examples{
\dontrun{
D = TimsR('path/to/your/folder.d')
print(query(D, c(1,20, 53)) # extract all columns
print(query(D, c(1,20, 53), columns=c('scan','intensity')) # only 'scan' and 'intensity'
}
}
