% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tk_make_timeseries.R
\name{tk_make_future_timeseries}
\alias{tk_make_future_timeseries}
\title{Make a future time series from an existing time series}
\usage{
tk_make_future_timeseries(idx, n_future, skip_values = NULL,
  inspect_weekdays = TRUE)
}
\arguments{
\item{idx}{A vector of dates}

\item{n_future}{Number of future observations}

\item{skip_values}{A vector of same class as \code{idx} of timeseries
values to skip.}

\item{inspect_weekdays}{Uses a logistic regression algorithm to inspect
whether certain weekdays (e.g. weekends) should be excluded from the future dates.
Default is \code{TRUE}.}
}
\value{
A vector containing future dates
}
\description{
Make a future time series from an existing time series
}
\details{
\code{tk_make_future_timeseries} returns a time series based
on the input index frequency and attributes.

The argument \code{n_future} determines how many future index observations to compute.

The \code{skip_values} argument can be used to pass a timeseries vector of values to skip.
This argument is good for passing holidays or special index values that should
be excluded from the future time series.
The values must be the same format as the \code{idx} class.

The \code{inspect_weekdays} argument applies to "daily" (scale = "day") data
(refer to \code{tk_get_timeseries_summary()} to get the index scale).
The default is \code{TRUE}, which runs a logistic regression on the weekdays to
determine if certain weekdays should be excluded from the future dates.
}
\examples{
library(tidyquant)
library(timekit)

# Basic example
idx <- c("2016-01-01 00:00:00",
         "2016-01-01 00:00:03",
         "2016-01-01 00:00:06") \%>\%
    ymd_hms()
# Make next three dates in series
idx \%>\%
    tk_make_future_timeseries(n_future = 3)


# Create index of days that FB stock will be traded in 2017 based on 2016 + holidays
FB_tbl <- FANG \%>\% filter(symbol == "FB")
holidays <- c("2017-01-02", "2017-01-16", "2017-02-20",
              "2017-04-14", "2017-05-29", "2017-07-04",
              "2017-09-04", "2017-11-23", "2017-12-25") \%>\%
    ymd()
# Remove holidays with skip_values, and remove weekends with inspect_weekdays = TRUE
FB_tbl \%>\%
    tk_index() \%>\%
    tk_make_future_timeseries(n_future         = 251,
                              skip_values      = holidays,
                              inspect_weekdays = TRUE)

# Works with regularized indexes as well
c(2016.00, 2016.25, 2016.50, 2016.75) \%>\%
    tk_make_future_timeseries(n_future = 4)

# Works with zoo yearmon and yearqtr too
c("2016 Q1", "2016 Q2", "2016 Q3", "2016 Q4") \%>\%
    as.yearqtr() \%>\%
    tk_make_future_timeseries(n_future = 4)


}
\seealso{
\code{\link[=tk_index]{tk_index()}}, \code{\link[=tk_get_timeseries_summary]{tk_get_timeseries_summary()}}, \code{\link[=tk_get_timeseries_signature]{tk_get_timeseries_signature()}}
}
