% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{findUnmutatedCalls}
\alias{findUnmutatedCalls}
\title{Determine which calls represent an unmutated allele}
\usage{
findUnmutatedCalls(allele_calls, sample_seqs, germline_db)
}
\arguments{
\item{allele_calls}{a vector of strings respresenting Ig allele calls,
where multiple calls are separated by a comma}

\item{sample_seqs}{V(D)J-rearranged sample sequences matching the order
of the given \code{allele_calls}}

\item{germline_db}{a vector of named nucleotide germline sequences}
}
\value{
A vector of strings containing the members of \code{allele_calls}
          that represent unmutated sequences
}
\description{
\code{findUnmutatedCalls} determines which allele calls would represent a 
perfect match with the germline sequence, given a vector of allele calls and
mutation counts. In the case of multiple alleles being assigned to a
sequence, only the subset that would represent a perfect match is returned.
}
\examples{
# Load data
data(germline_ighv)
data(sample_db)

# Find which of the sample alleles are unmutated
calls <- findUnmutatedCalls(sample_db$V_CALL, sample_db$SEQUENCE_IMGT, 
         germline_db=germline_ighv)
head(calls)

}

