\name{ChisqSimSlow}
\alias{ChisqSimSlow}
\title{Chi Square Resampler (One at a Time)}
\usage{
ChisqSimSlow(form,data,effects="random")
}
\arguments{
  \item{form}{a formula of the form ~x+y.  When using fixed
  effects (see below for explanation), x should be the
  variable that is considered the predictor variable.}

  \item{data}{A data frame from which x and y are drawn.}

  \item{effects}{When effects="fixed", the resampling is
  performed under the conditon that the row sums in the
  resampled two-way table (with x for rows) are the same as
  the row sums in the twoway table based on the original
  data.  When effects="random", then both row and column
  sums in the resampled table may vary: only the sum of the
  counts is constant.  (Note: in the resampling procedure
  for chisq.test in the stats package of R, both row and
  column sums are required to equal the corresponding sums
  for the original data.)}
}
\value{
Graphical and numerical output
}
\description{
An app to illustrate use of the chi-square statistic to
test for a relationship between two categorical variables.
The P-value is computed by resampling, and the resamples
are done one at a time.  A histogram of resampled
chi-square statistics is displayed after each resample, and
summary information is output to the console.
}
\examples{
\dontrun{
if (require(manipulate)) ChisqSimSlow(~weather+crowd.behavior,data=ledgejump,effects="fixed")
}
}
\author{
Homer White \email{hwhite0@georgetowncollege.edu}
}

