% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maybe_xlsx.R
\name{maybe_xlsx}
\alias{maybe_xlsx}
\title{Determine file format}
\usage{
maybe_xlsx(path)
}
\arguments{
\item{path}{File path}
}
\value{
Logicial
}
\description{
Whether a file may be be xlsx, xlsm, xltx or xltm (rather than xls or xlt),
based on the \href{https://en.wikipedia.org/wiki/List_of_file_signatures}{filesignature} or "magic
number", rather than the filename extension.
}
\details{
Only 'maybe', not 'is', because the xlsx magic number is common to all zip
files, not specific to xlsx files.  The inverse, 'is_xls' isn't possible
either, because the xls magic number is common to other Microsoft Office
files such as .doc and .ppt.

This uses some logic from Jenny Bryan's commit to the
\href{https://github.com/tidyverse/readxl/commit/ff071a4758da3677568362daff52e419c4e0cdfe}{readxl}
package.
}
\examples{
examples_xlsx <- system.file("extdata/examples.xlsx", package = "tidyxl")
examples_xlsm <- system.file("extdata/examples.xlsm", package = "tidyxl")
examples_xltx <- system.file("extdata/examples.xltx", package = "tidyxl")
examples_xltm <- system.file("extdata/examples.xltm", package = "tidyxl")
examples_xlsb <- system.file("extdata/examples.xlsb", package = "tidyxl")
examples_xls <- system.file("extdata/examples.xls", package = "tidyxl")

maybe_xlsx(examples_xlsx)
maybe_xlsx(examples_xlsm)
maybe_xlsx(examples_xltx)
maybe_xlsx(examples_xltm)
maybe_xlsx(examples_xlsb)
maybe_xlsx(examples_xls)
}
