% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpcstats.R
\name{binningfunctions}
\alias{binningfunctions}
\alias{cut_at}
\alias{nearest}
\alias{bin_by_ntile}
\alias{bin_by_eqcut}
\alias{bin_by_pam}
\alias{bin_by_classInt}
\title{Different functions that perform binning.}
\usage{
cut_at(breaks)

nearest(centers)

bin_by_ntile(nbins)

bin_by_eqcut(nbins)

bin_by_pam(nbins)

bin_by_classInt(style, nbins = NULL)
}
\arguments{
\item{breaks}{A numeric vector of values that designate cut points between bins.}

\item{centers}{A numeric vector of values that designate the center of each bin.}

\item{nbins}{The number of bins to split the data into.}

\item{style}{a binning style (see \link[classInt]{classIntervals} for details).}
}
\value{
Each of these functions returns a function of a single numeric
vector `x` that assigns each value of `x` to a bin.
}
\description{
Different functions that perform binning.
}
\examples{

x <- c(rnorm(10, 1, 1), rnorm(10, 3, 2), rnorm(20, 5, 3))
centers <- c(1, 3, 5)
nearest(centers)(x)

breaks <- c(2, 4)
cut_at(breaks)(x)

bin_by_eqcut(nbins=4)(x)
bin_by_ntile(nbins=4)(x)

bin_by_pam(nbins=4)(x)
bin_by_classInt("pretty", nbins=4)(x)

}
