% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnest_char.R
\name{unnest_characters}
\alias{unnest_characters}
\alias{unnest_character_shingles}
\title{Wrapper around unnest_tokens for characters and character shingles}
\usage{
unnest_characters(
  tbl,
  output,
  input,
  strip_non_alphanum = TRUE,
  format = c("text", "man", "latex", "html", "xml"),
  to_lower = TRUE,
  drop = TRUE,
  collapse = NULL,
  ...
)

unnest_character_shingles(
  tbl,
  output,
  input,
  n = 3L,
  n_min = n,
  strip_non_alphanum = TRUE,
  format = c("text", "man", "latex", "html", "xml"),
  to_lower = TRUE,
  drop = TRUE,
  collapse = NULL,
  ...
)
}
\arguments{
\item{tbl}{A data frame}

\item{output}{Output column to be created as string or symbol.}

\item{input}{Input column that gets split as string or symbol.

The output/input arguments are passed by expression and support
\link[rlang:topic-inject]{quasiquotation}; you can unquote strings and symbols.}

\item{strip_non_alphanum}{Should punctuation and white space be stripped?}

\item{format}{Either "text", "man", "latex", "html", or "xml". When the
format is "text", this function uses the tokenizers package. If not "text",
this uses the hunspell tokenizer, and can tokenize only by "word".}

\item{to_lower}{Whether to convert tokens to lowercase.}

\item{drop}{Whether original input column should get dropped. Ignored
if the original input and new output column have the same name.}

\item{collapse}{A character vector of variables to collapse text across,
or \code{NULL}.

For tokens like n-grams or sentences, text can be collapsed across rows
within variables specified by \code{collapse} before tokenization. At tidytext
0.2.7, the default behavior for \code{collapse = NULL} changed to be more
consistent. The new behavior is that text is \emph{not} collapsed for \code{NULL}.

Grouping data specifies variables to collapse across in the same way as
\code{collapse} but you \strong{cannot} use both the \code{collapse} argument and
grouped data. Collapsing applies mostly to \code{token} options of "ngrams",
"skip_ngrams", "sentences", "lines", "paragraphs", or "regex".}

\item{...}{Extra arguments passed on to \link[tokenizers:tokenizers]{tokenizers}}

\item{n}{The number of characters in each shingle. This must be an integer
greater than or equal to 1.}

\item{n_min}{This must be an integer greater than or equal to 1, and less
than or equal to \code{n}.}
}
\description{
These functions are a wrapper around \code{unnest_tokens( token = "characters" )}
and \code{unnest_tokens( token = "character_shingles" )}.
}
\examples{
library(dplyr)
library(janeaustenr)

d <- tibble(txt = prideprejudice)

d \%>\%
  unnest_characters(word, txt)

d \%>\%
  unnest_character_shingles(word, txt, n = 3)

}
\seealso{
\itemize{
\item \code{\link[=unnest_tokens]{unnest_tokens()}}
}
}
