% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inv_gc.R
\name{inv_gc}
\alias{inv_gc}
\title{Run invisible garbage collection}
\usage{
inv_gc(x)
}
\arguments{
\item{x}{Optional. If missing runs \code{gc()} silently. Else returns the same object unaltered.}
}
\description{
Run garbage collection without the \code{gc()} output. Can also be run in the middle of a long pipe chain.
Useful for large datasets or when using parallel processing.
}
\examples{
# Can be run with no input
inv_gc()

df <- tidytable(col1 = 1, col2 = 2)

# Or can be used in the middle of a pipe chain (object is unaltered)
df \%>\%
  filter.(col1 < 2, col2 < 4) \%>\%
  inv_gc() \%>\%
  select.(col1)
}
