% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_longer.R
\name{dt_pivot_longer}
\alias{dt_pivot_longer}
\title{Pivot data from wide to long}
\usage{
dt_pivot_longer(
  .data,
  cols = dt_everything(),
  names_to = "name",
  values_to = "value",
  values_drop_na = FALSE,
  ...
)
}
\arguments{
\item{.data}{The data table to pivot longer}

\item{cols}{Vector of bare column names. Can add/drop columns.}

\item{names_to}{Name of the new "names" column. Must be a string.}

\item{values_to}{Name of the new "values" column. Must be a string.}

\item{values_drop_na}{If TRUE, rows will be dropped that contain NAs.}

\item{...}{Additional arguments to pass to `melt.data.table()`}
}
\description{
\code{dt_pivot_wider()} "widens" data, increasing the number of columns and
decreasing the number of rows. The inverse transformation is
\code{dt_pivot_longer()}. Syntax based on the \code{tidyr} equivalents.

Supports enhanced selection
}
\examples{
example_dt <- data.table::data.table(
  x = c(1,2,3),
  y = c(4,5,6),
  z = c("a", "b", "c"))

dt_pivot_longer(example_dt,
                cols = c(x, y),
                names_to = "stuff",
                values_to = "things")

dt_pivot_longer(example_dt,
                cols = -z,
                names_to = "stuff",
                values_to = "things")

}
