% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_stat.r
\name{custom_stat}
\alias{custom_stat}
\title{Create a custom statistic}
\usage{
custom_stat(
  name,
  value,
  symbol = NULL,
  subscript = NULL,
  interval = NULL,
  level = NULL,
  lower = NULL,
  upper = NULL
)
}
\arguments{
\item{name}{A string specifying the name of the statistic.}

\item{value}{The numeric value of the statistic.}

\item{symbol}{A string specifying the symbol of the statistic to use when
reporting the statistic.}

\item{subscript}{A string specifying a subscript to use when reporting the
statistic.}

\item{interval}{A string specifying the type of interval if the statistic is
a ranged statistic (e.g., 95\% confidence interval)}

\item{level}{A numeric value between 0 and 1 indicating the level of the
interval.}

\item{lower}{The numeric value of the lower bound of the statistic.}

\item{upper}{The numeric value of the upper bound of the statistic.}
}
\description{
\code{\link[=custom_stat]{custom_stat()}} is used together with the \code{\link[=custom_stats]{custom_stats()}} function to add
statistics from unsupported functions via \code{\link[=add_stats]{add_stats()}}. See the
\code{\link[=custom_stats]{custom_stats()}} function for more information.
}
\examples{
# Example 1: A single mean value
sample <- rnorm(1000, mean = 0, sd = 1)
mean <- mean(sample)

custom_stat(name = "mean", value = mean, symbol = "M")

# Example 2: A mean with a 95\% confidence interval
sample <- rnorm(1000, mean = 0, sd = 1)
mean <- mean(sample)
se <- sd(sample) / sqrt(length(sample))
CI <- c(mean - 1.96 * se, mean + 1.96 * se)

custom_stat(
  name = "mean",
  value = mean,
  symbol = "M",
  interval = "CI",
  level = .95,
  lower = CI[1],
  upper = CI[2]
)

}
