% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_stats.lmerMod.r
\name{tidy_stats.lmerMod}
\alias{tidy_stats.lmerMod}
\title{Create a tidy stats data frame from an lmerMod object}
\usage{
\method{tidy_stats}{lmerMod}(model)
}
\arguments{
\item{model}{Output of lme4's \code{lmer()}.}
}
\description{
\code{tidy_stats.lmerMod} takes an lmerMod object and converts the object to
a tidy stats data frame.
}
\examples{
\donttest{
  # Load package
  library(lme4)

  # Conduct a linear mixed model
  model_lmer <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)

  # Tidy stats
  tidy_stats(model_lmer)
}

}
