% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot-geom_chart.R
\name{geom_chart}
\alias{geom_chart}
\alias{geom_barchart}
\alias{geom_candlestick}
\title{Plot Financial Charts in ggplot2}
\usage{
geom_barchart(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  na.rm = TRUE,
  show.legend = NA,
  inherit.aes = TRUE,
  colour_up = "darkblue",
  colour_down = "red",
  fill_up = "darkblue",
  fill_down = "red",
  ...
)

geom_candlestick(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  na.rm = TRUE,
  show.legend = NA,
  inherit.aes = TRUE,
  colour_up = "darkblue",
  colour_down = "red",
  fill_up = "darkblue",
  fill_down = "red",
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{ggplot2::aes()}} or
\code{\link[ggplot2:aes_]{ggplot2::aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{ggplot2::fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame.}, and
will be used as the layer data.}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{na.rm}{If \code{TRUE}, silently removes \code{NA} values, which
typically desired for moving averages.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{ggplot2::borders()}}.}

\item{colour_up, colour_down}{Select colors to be applied based on price movement
from open to close. If close >= open, \code{colour_up} is used. Otherwise,
\code{colour_down} is used. The default is "darkblue" and "red", respectively.}

\item{fill_up, fill_down}{Select fills to be applied based on price movement
from open to close. If close >= open, \code{fill_up} is used. Otherwise,
\code{fill_down} is used. The default is "darkblue" and "red", respectively.
Only affects \code{geom_candlestick}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{ggplot2::layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\description{
Financial charts provide visual cues to open, high, low, and close prices.
Use \code{\link[=coord_x_date]{coord_x_date()}} to zoom into specific plot regions.
The following financial chart geoms are available:
\itemize{
\item \strong{\href{https://www.investopedia.com/terms/b/barchart.asp}{Bar Chart}}
\item \strong{\href{https://www.investopedia.com/terms/c/candlestick.asp}{Candlestick Chart}}
}
}
\section{Aesthetics}{

The following aesthetics are understood (required are in bold):
\itemize{
\item \strong{\code{x}}, Typically a date
\item \strong{\code{open}}, Required to be the open price
\item \strong{\code{high}}, Required to be the high price
\item \strong{\code{low}}, Required to be the low price
\item \strong{\code{close}}, Required to be the close price
\item \code{alpha}
\item \code{group}
\item \code{linetype}
\item \code{size}
}
}

\examples{
# Load libraries
library(tidyquant)
library(dplyr)
library(ggplot2)

AAPL <- tq_get("AAPL", from = "2013-01-01", to = "2016-12-31")

# Bar Chart
AAPL \%>\%
    ggplot(aes(x = date, y = close)) +
    geom_barchart(aes(open = open, high = high, low = low, close = close)) +
    geom_ma(color = "darkgreen") +
    coord_x_date(xlim = c("2016-01-01", "2016-12-31"),
                 ylim = c(75, 125))

# Candlestick Chart
AAPL \%>\%
    ggplot(aes(x = date, y = close)) +
    geom_candlestick(aes(open = open, high = high, low = low, close = close)) +
    geom_ma(color = "darkgreen") +
    coord_x_date(xlim = c("2016-01-01", "2016-12-31"),
                 ylim = c(75, 125))
}
\seealso{
See individual modeling functions for underlying parameters:
\itemize{
\item \code{\link[=geom_ma]{geom_ma()}} for adding moving averages to ggplots
\item \code{\link[=geom_bbands]{geom_bbands()}} for adding Bollinger Bands to ggplots
\item \code{\link[=coord_x_date]{coord_x_date()}} for zooming into specific regions of a plot
}
}
