% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-predictions.R
\name{tidypredict_test}
\alias{tidypredict_test}
\title{Tests base predict function against tidypredict}
\usage{
tidypredict_test(
  model,
  df = model$model,
  threshold = 1e-12,
  include_intervals = FALSE,
  max_rows = NULL,
  xg_df = NULL
)
}
\arguments{
\item{model}{An R model or a list with a parsed model. It currently supports
lm(), glm() and randomForest() models.}

\item{df}{A data frame that contains all of the needed fields to run the prediction.
It defaults to the "model" data frame object inside the model object.}

\item{threshold}{The number that a given result difference, between predict() and
tidypredict_to_column() should not exceed. For continuous predictions, the default
value is 0.000000000001 (1e-12), and for categorical predictions, the default value is
0.}

\item{include_intervals}{Switch to indicate if the prediction intervals should be
included in the test. It defaults to FALSE.}

\item{max_rows}{The number of rows in the object passed in the df argument. Highly
recommended for large data sets.}

\item{xg_df}{A xgb.DMatrix object, required only for XGBoost models. It defaults to
NULL
recommended for large data sets.}
}
\description{
Compares the results of predict() and tidypredict_to_column()
functions.
}
\examples{

model <- lm(mpg ~ wt + cyl * disp, offset = am, data = mtcars)
tidypredict_test(model)
}
