% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-interval.R
\name{tidypredict_interval}
\alias{tidypredict_interval}
\title{Returns a Tidy Eval formula to calculate prediction interval}
\usage{
tidypredict_interval(model, interval = 0.95)
}
\arguments{
\item{model}{An R model or a tibble with a parsed model. It currently supports
lm() models only.}

\item{interval}{The prediction interval, defaults to 0.95}
}
\description{
It parses a model or uses an already parsed model to return a
Tidy Eval formula that can then be used inside a dplyr command.
}
\details{
The result still has to be added to the fit to obtain the upper bound, and
subtracted from fit to obtain the lower bound.
}
\examples{

library(dplyr)
df <- mutate(mtcars, cyl = paste0("cyl", cyl))
model <- lm(mpg ~ wt + cyl * disp, offset = am, data = df)
tidypredict_interval(model)

}
