% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posteriors.R
\name{tidy.perf_mod}
\alias{tidy.perf_mod}
\title{Extract Posterior Distributions for Models}
\usage{
\method{tidy}{perf_mod}(x, seed = sample.int(10000, 1), ...)
}
\arguments{
\item{x}{An object from \code{\link[=perf_mod]{perf_mod()}}}

\item{seed}{A single integer for sampling from the posterior.}

\item{...}{Not currently used}
}
\value{
A data frame with the additional class \code{"posterior"}
}
\description{
\code{tidy} can be used on an object produced by \code{\link[=perf_mod]{perf_mod()}}
to create a data frame with a column for the model name and
the posterior predictive distribution values.
}
\details{
Note that this posterior only reflects the variability
of the groups (i.e. the fixed effects). This helps answer the
question of which model is best \emph{for this data set}. If does not
answer the question of which model would be best on a new
resample of the data (which would have greater variability).
}
\examples{
# Example objects from the "Getting Started" vignette at
#  https://topepo.github.io/tidyposterior/articles/Getting_Started.html

file <- system.file("examples", "roc_model.RData", package = "tidyposterior")
load(file)

roc_model
posterior_values <- tidy(roc_model)
head(posterior_values)
class(posterior_values)

}
