% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop-uninformative-columns.R
\name{drop_uninformative_columns}
\alias{drop_uninformative_columns}
\title{Drop uninformative columns from a data frame}
\usage{
drop_uninformative_columns(data, na_distinct = TRUE)
}
\arguments{
\item{data}{A data frame.}

\item{na_distinct}{A flag specifying whether to treat missing values
as distinct from other values.}
}
\value{
The original data frame with only informative columns.
}
\description{
This is a convenient way to drop columns which all have one value (missing or not) or
if \code{na_distinct = FALSE} also drop columns which all have one value and/or missing values.
}
\examples{
data <- tibble::tibble(
  a = c(1,1,1), x = c(NA, NA, NA), b = c(1, 1, NA), 
  z = c(1, 2, 2), e = c(1, 2, NA))

drop_uninformative_columns(data)
drop_uninformative_columns(data, na_distinct = FALSE)
}
