% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hy_sed_samples_psd.R
\name{hy_sed_samples_psd}
\alias{hy_sed_samples_psd}
\title{Extract instantaneous sediment sample particle size distribution information from the HYDAT database}
\format{
A tibble with 5 variables:
\describe{
\item{STATION_NUMBER}{Unique 7 digit Water Survey of Canada station number}
\item{SED_DATA_TYPE}{Contains the type of sampling method used in collecting sediment for a station}
\item{Date}{Contains the time to the nearest minute of when the sample was taken}
\item{PARTICLE_SIZE}{Particle size (mm)}
\item{PERCENT}{Contains the percentage values for indicated particle sizes for samples collected}
}
}
\source{
HYDAT
}
\usage{
hy_sed_samples_psd(
  station_number = NULL,
  hydat_path = NULL,
  prov_terr_state_loc = NULL,
  start_date = NULL,
  end_date = NULL
)
}
\arguments{
\item{station_number}{A seven digit Water Survey of Canada station number. If this argument is omitted, the value of \code{prov_terr_state_loc}
is returned.}

\item{hydat_path}{The path to the hydat database or NULL to use the default location
used by \link{download_hydat}. It is also possible to pass in an existing
\link[dplyr]{src_sqlite} such that the database only needs to be opened once per
user-level call.}

\item{prov_terr_state_loc}{Province, state or territory. If this argument is omitted, the value of \code{station_number}
is returned. See \code{unique(allstations$prov_terr_state_loc)}. Will also accept \code{CA} to return only Canadian stations.}

\item{start_date}{Leave blank if all dates are required. Date format needs to be in YYYY-MM-DD. Date is inclusive.}

\item{end_date}{Leave blank if all dates are required. Date format needs to be in YYYY-MM-DD. Date is inclusive.}
}
\value{
A tibble of sediment sample particle size data
}
\description{
Provides wrapper to turn the hy_sed_samples_psd table in HYDAT into a tidy data frame of instantaneous sediment sample
particle size distribution.  \code{station_number} and \code{prov_terr_state_loc} can both be supplied. If both
are omitted all values from the \code{\link[=hy_stations]{hy_stations()}} table are returned. That is a large vector for \code{hy_sed_samples_psd}.
}
\examples{
\dontrun{
hy_sed_samples_psd(station_number = "01CA004")
}

}
\seealso{
Other HYDAT functions: 
\code{\link{hy_agency_list}()},
\code{\link{hy_annual_instant_peaks}()},
\code{\link{hy_annual_stats}()},
\code{\link{hy_daily_flows}()},
\code{\link{hy_daily_levels}()},
\code{\link{hy_daily}()},
\code{\link{hy_data_symbols}},
\code{\link{hy_data_types}},
\code{\link{hy_datum_list}()},
\code{\link{hy_monthly_flows}()},
\code{\link{hy_monthly_levels}()},
\code{\link{hy_reg_office_list}()},
\code{\link{hy_sed_daily_loads}()},
\code{\link{hy_sed_daily_suscon}()},
\code{\link{hy_sed_monthly_loads}()},
\code{\link{hy_sed_monthly_suscon}()},
\code{\link{hy_sed_samples}()},
\code{\link{hy_stations}()},
\code{\link{hy_stn_data_coll}()},
\code{\link{hy_stn_data_range}()},
\code{\link{hy_stn_op_schedule}()},
\code{\link{hy_stn_regulation}()},
\code{\link{hy_version}()}
}
\concept{HYDAT functions}
