% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distinct.R
\name{distinct}
\alias{distinct}
\title{Select distinct/unique rows in data.table}
\usage{
distinct(.data, ..., .keep_all = FALSE)
}
\arguments{
\item{.data}{data.table}

\item{...}{Optional variables to use when determining uniqueness.
If there are multiple rows for a given combination of inputs,
only the first row will be preserved.
If omitted, will use all variables.}

\item{.keep_all}{If \code{TRUE}, keep all variables in data.table. If a combination of ... is not distinct,
this keeps the first row of values.}
}
\value{
data.table
}
\description{
Analogous function for \code{distinct} in \pkg{dplyr}
}
\examples{

 a = as.data.table(iris)
 b = as.data.table(mtcars)
 a \%>\% distinct(Species)
 b \%>\% distinct(cyl,vs,.keep_all = TRUE)


}
\seealso{
\code{\link[dplyr]{distinct}}
}
