% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print_options}
\alias{print_options}
\title{Set global printing method for data.table}
\usage{
print_options(
  topn = 5,
  nrows = 100,
  class = TRUE,
  row.names = TRUE,
  col.names = "auto",
  print.keys = TRUE,
  trunc.cols = FALSE
)
}
\arguments{
\item{topn}{The number of rows to be printed from the beginning and
end of tables with more than \code{nrow} rows.}

\item{nrows}{The number of rows which will be printed before truncation is enforced.}

\item{class}{If \code{TRUE}, the resulting output will include above each column its storage class (or a self-evident abbreviation thereof).}

\item{row.names}{If \code{TRUE}, row indices will be printed.}

\item{col.names}{One of three flavours for controlling the display of column names in output. \code{"auto"} includes column names above the data, as well as below the table if \code{nrow(x) > 20}. \code{"top"} excludes this lower register when applicable, and \code{"none"} suppresses column names altogether (as well as column classes if \code{class = TRUE}.}

\item{print.keys}{If \code{TRUE}, any \code{\link{key}} currently assigned to \code{x} will be printed prior to the preview of the data.}

\item{trunc.cols}{If \code{TRUE}, only the columns that can be printed in the console without wrapping the columns to new lines will be printed (similar to \code{tibbles}).}
}
\value{
None. This function is used for its side effect of changing options.
}
\description{
This function allow user to define how data.table is printed.
}
\details{
Notice that \pkg{tidyfst} has a slightly different printing default for data.table,
 which is it always prints the keys and variable class (not like \pkg{data.table}).
}
\examples{

iris \%>\% as.data.table()
print_options(topn = 3,trunc.cols = TRUE)
iris \%>\% as.data.table()

# set all settings to default in tidyfst
print_options()
iris \%>\% as.data.table()

}
\seealso{
\code{\link[data.table]{print.data.table}}
}
