% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_summary.R
\name{extract_fit_summary}
\alias{extract_fit_summary}
\title{S3 method to get fitted model summary info depending on engine}
\usage{
extract_fit_summary(object, ...)
}
\arguments{
\item{object}{a fitted cluster_spec object}

\item{...}{other arguments passed to methods}
}
\value{
A list with various summary elements
}
\description{
S3 method to get fitted model summary info depending on engine
}
\details{
The elements \code{cluster_names} and \code{cluster_assignments} will be factors.
}
\examples{
kmeans_spec <- k_means(num_clusters = 5) \%>\%
  set_engine("stats")

kmeans_fit <- fit(kmeans_spec, ~., mtcars)

kmeans_fit \%>\%
  extract_fit_summary()
}
