% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_draws.R
\name{tidy_draws}
\alias{tidy_draws}
\alias{tidy_draws.default}
\alias{tidy_draws.draws}
\alias{tidy_draws.data.frame}
\alias{tidy_draws.mcmc.list}
\alias{tidy_draws.stanfit}
\alias{tidy_draws.stanreg}
\alias{tidy_draws.runjags}
\alias{tidy_draws.jagsUI}
\alias{tidy_draws.brmsfit}
\alias{tidy_draws.CmdStanFit}
\alias{tidy_draws.CmdStanMCMC}
\alias{tidy_draws.matrix}
\alias{tidy_draws.MCMCglmm}
\title{Get a sample of posterior draws from a model as a tibble}
\usage{
tidy_draws(model, ...)

\method{tidy_draws}{default}(model, ...)

\method{tidy_draws}{draws}(model, ...)

\method{tidy_draws}{data.frame}(model, ...)

\method{tidy_draws}{mcmc.list}(model, ...)

\method{tidy_draws}{stanfit}(model, ...)

\method{tidy_draws}{stanreg}(model, ...)

\method{tidy_draws}{runjags}(model, ...)

\method{tidy_draws}{jagsUI}(model, ...)

\method{tidy_draws}{brmsfit}(model, ...)

\method{tidy_draws}{CmdStanFit}(model, ...)

\method{tidy_draws}{CmdStanMCMC}(model, ...)

\method{tidy_draws}{matrix}(model, ...)

\method{tidy_draws}{MCMCglmm}(model, ...)
}
\arguments{
\item{model}{A supported Bayesian model fit. Tidybayes supports a variety of model objects;
for a full list of supported models, see \link{tidybayes-models}.}

\item{...}{Further arguments passed to other methods (mostly unused).}
}
\value{
A data frame (actually, a \link[tibble:tibble]{tibble}) with a \code{.chain} column,
\code{.iteration} column, \code{.draw} column, and one column for every variable in \code{model}.
}
\description{
Extract draws from a Bayesian fit into a wide-format data frame with a
\code{.chain}, \code{.iteration}, and \code{.draw} column, as well as all variables
as columns. This function does not parse indices from variable names
(e.g. for variable names like \code{"x[1]"}); see \code{\link[=spread_draws]{spread_draws()}} or
\code{\link[=gather_draws]{gather_draws()}} for functions that parse variable indices.
}
\details{
This function can be useful for quick glances at models (especially
combined with \code{\link[=gather_variables]{gather_variables()}} and \code{\link[=median_qi]{median_qi()}}), and for models with
parameters without indices in their names (like \code{"x[1]"}).
\code{\link[=spread_draws]{spread_draws()}} and \code{\link[=gather_draws]{gather_draws()}}, which \emph{do} parse variable name indices,
call this function internally if their input is not already a tidy data frame.

To provide support for new models in tidybayes,
you must provide an implementation of this function \emph{or} an implementation
of \code{\link[coda:mcmc.list]{coda::as.mcmc.list()}} (\code{tidy_draws} should work on any model
with an implementation of \code{\link[coda:mcmc.list]{coda::as.mcmc.list()}})

\code{tidy_draws()} can be applied to a data frame that is already a tidy-format data frame
of draws, provided it has one row per draw. In other words, it can be applied to data frames
that have the same format it returns, and it will return the same data frame back, while
checking to ensure the \code{.chain}, \code{.iteration}, and \code{.draw} columns are all
integers (converting if possible) and that the \code{.draw} column is unique. This allows
you to pass already-tidy-format data frames into other tidybayes functions, like
\code{\link[=spread_draws]{spread_draws()}} or \code{\link[=gather_draws]{gather_draws()}}. This functionality can be useful if the
tidying step is expensive: you can tidy once, possibly subsetting to some
particular variables of interest, then call \code{\link[=spread_draws]{spread_draws()}} or \code{\link[=gather_draws]{gather_draws()}}
repeatedly to extract variables and indices from the already-tidied data frame.
}
\examples{

library(magrittr)

data(line, package = "coda")

line \%>\%
  tidy_draws()

}
\seealso{
\code{\link[=spread_draws]{spread_draws()}} or \code{\link[=gather_draws]{gather_draws()}}, which use this function
internally and provides a friendly interface for extracting tidy data frames from model fits.
}
\author{
Matthew Kay
}
\keyword{manip}
