% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results-table_results.R
\name{table_results}
\alias{table_results}
\title{Print results table formatted for publication}
\usage{
table_results(
  x,
  columns = c("label", "est_sig", "se", "pval", "confint", "group", "level"),
  digits = 2,
  ...
)
}
\arguments{
\item{x}{A model object for which a method exists.}

\item{columns}{A character vector of columns to retain from the results
section. If this is set to \code{NULL}, all available columns are returned.
Defaults to \code{c("label", "est_sig", "se", "pval", "confint", "group",
"level")}. These correspond to 1) the parameter label, 2) estimate column
with significance asterisks appended
(\* <.05, \*\* < .01, \*\*\* < .001); 3) standard error, 4) p-value, 5) a
formatted confidence interval, 6) grouping variable (if available), 7) level
variable for multilevel models, if available.}

\item{digits}{Number of digits to round to when formatting numeric columns.}

\item{...}{Logical expressions used to filter the rows of results returned.}
}
\value{
A data.frame of formatted results.
}
\description{
Takes a model object, and formats it as a publication-ready table.
}
\examples{
library(lavaan)
HS.model <- '  visual =~ x1 + x2 + x3
               textual =~ x4 + x5 + x6
               speed   =~ x7 + x8 + x9 '
fit <- cfa(HS.model,
           data = HolzingerSwineford1939,
           group = "school")
table_results(fit)
}
\seealso{
Other Reporting tools: 
\code{\link{conf_int}()},
\code{\link{est_sig}()}
}
\author{
Caspar J. van Lissa
}
\concept{Reporting tools}
\keyword{reporting}
