% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nb_bars.R
\name{nb_bars}
\alias{nb_bars}
\title{Create stacked bar charts based on negative binomial model estimates}
\usage{
nb_bars(
  modsum,
  ...,
  range,
  quant_style = c("continuous", "discrete"),
  top_taxa = 0,
  RA = 0,
  specific_taxa = NULL,
  lines = TRUE,
  xaxis,
  main,
  subtitle,
  xlab,
  ylab,
  facet_labels = NULL,
  facet_layout = 1
)
}
\arguments{
\item{modsum}{The output from nb_mods}

\item{...}{The covariate you'd like to plot. Can be an interaction term or main effect, but must be in the models created by nb_mods}

\item{range}{The range you'd like to plot over for a quantitative variable. Will default to the IQR}

\item{quant_style}{"continuous" will plot over the entire range specified; "discrete" will plot only the endpoints of the range specified. "continuous" by default. This option is ignored without a quantitative variable}

\item{top_taxa}{Only plot X taxa with the highest relative abundance. The rest will be aggregated into an "Other" category}

\item{RA}{Only plot taxa with a relative abundance higher than X. The rest will be aggregated into an "Other" category}

\item{specific_taxa}{Plot this specific taxa even if it doesn't meet the top_taxa or RA requirements}

\item{lines}{Logical; Add outlines around the different taxa colors in the stacked bar charts}

\item{xaxis}{Labels for the x-axis ticks. Most useful for categorical variables and defaults to the levels}

\item{main}{Plot title}

\item{subtitle}{Subtitle for the plot}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{facet_labels}{Labels for the facets created for interaction terms}

\item{facet_layout}{Rearrange the facets created for interaction terms}
}
\value{
Returns a ggplot that you can add geoms to if you'd like
}
\description{
nb_bars takes the output from nb_mods and creates stacked bar charts of the estimated relative abundance for each taxa. The benefit of modeling each taxa before created stacked bar charts is the ability to control for potential confounders. The function will facet wrap interaction terms. Currently, only quant_style "discrete" can be used for an interaction between two quantitative variables
}
\examples{
data(bpd_phy); data(bpd_cla); data(bpd_ord); data(bpd_fam); data(bpd_clin)
otu_tabs = list(Phylum = bpd_phy, Class = bpd_cla,
Order = bpd_ord, Family = bpd_fam)

set <- tidy_micro(otu_tabs = otu_tabs, clinical = bpd_clin) \%>\%
filter(day == 7) ## Only including the first week

## Creating negative binomial models on filtered tidy_micro set
nb_fam <- set \%>\%
otu_filter(ra_cutoff = 0.1, exclude_taxa = c("Unclassified", "Bacteria")) \%>\%
nb_mods(table = "Family", bpd1)

nb_fam \%>\%
nb_bars(bpd1, top_taxa = 9, xlab = "BPD Severity")
}
