% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{add_annotation}
\alias{add_annotation}
\title{add_annotation}
\source{
[Mangiola and Papenfuss., 2020](https://joss.theoj.org/papers/10.21105/joss.02472)
}
\usage{
add_annotation(
  my_input_heatmap,
  annotation,
  type = rep("tile", length(quo_names(annotation))),
  palette_discrete = list(),
  palette_continuous = list(),
  size = NULL,
  ...
)
}
\arguments{
\item{my_input_heatmap}{A `InputHeatmap` formatted as | <SAMPLE> | <TRANSCRIPT> | <COUNT> | <...> |}

\item{annotation}{Vector of quotes}

\item{type}{A character vector of the set c(\"tile\", \"point\", \"bar\", \"line\")}

\item{palette_discrete}{A list of character vectors. This is the list of palettes that will be used for horizontal and vertical discrete annotations. The discrete classification of annotations depends on the column type of your input tibble (e.g., character and factor).}

\item{palette_continuous}{A list of character vectors. This is the list of palettes that will be used for horizontal and vertical continuous annotations. The continuous classification of annotations depends on the column type of your input tibble (e.g., integer, numerical, double).}

\item{size}{A grid::unit object, e.g. unit(2, "cm"). This is the height or width of the annotation depending on the orientation.}

\item{...}{The arguments that will be passed to top_annotation or left_annotation of the ComplexHeatmap container}
}
\value{
A `ComplexHeatmap` object
}
\description{
add_annotation() takes a tbl object and easily produces a ComplexHeatmap plot, with integration with tibble and dplyr frameworks.
}
\details{
To be added.
}
\references{
Mangiola, S. and Papenfuss, A.T., 2020. "tidyHeatmap: an R package for 
  modular heatmap production based on tidy principles." Journal of Open Source Software.
  doi:10.21105/joss.02472.
}
