% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loaders.R
\name{template_subject}
\alias{template_subject}
\alias{N27}
\alias{download_template_subject}
\alias{download_N27}
\alias{set_default_template}
\alias{threebrain_finalize_installation}
\title{Download and Manage Template Subjects}
\usage{
download_template_subject(
  subject_code = "N27",
  url = "https://github.com/dipterix/threeBrain-sample/releases/download/1.0.0/N27.zip",
  template_dir = default_template_directory()
)

download_N27(make_default = FALSE, ...)

set_default_template(
  subject_code,
  view = TRUE,
  template_dir = default_template_directory()
)

threebrain_finalize_installation(
  upgrade = c("ask", "always", "never"),
  async = TRUE
)
}
\arguments{
\item{subject_code}{character with only letters and numbers (Important). Default is `N27`}

\item{url}{zip file address}

\item{template_dir}{parent directory where subject's `FreeSurfer` folder should be stored}

\item{make_default}{logical, whether to make `N27` default subject}

\item{...}{more to pass to \code{download_template_subject}}

\item{view}{whether to view the subject}

\item{upgrade}{whether to check and download 'N27' brain interactively.
Choices are 'ask', 'always', and 'never'}

\item{async}{whether to run the job in parallel to others; default is true}
}
\description{
Download and Manage Template Subjects
}
\details{
To view electrodes implanted in multiple subjects, it's highly
recommended to view them in a template space The detail mapping method
is discussed in function \code{freesurfer_brain}.

To map to a template space, one idea is to find someone whose brain is
normal. In our case, the choice is subject `N27`, also known as `Colin 27`.
function \code{download_N27} provides a simple and easy way to download a
partial version from the Internet.

If you have any other ideas about template brain, you can use function
\code{set_default_template(subject_code, template_dir)} to redirect to
your choice. If your template brain is a `Zip` file on the Internet, we
provide function \code{download_template_subject} to automatically install it.
}
\author{
Zhengjia Wang
}
