% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/witcher_spells.R
\name{scale_color_witcher}
\alias{scale_color_witcher}
\alias{scale_colour_witcher}
\alias{scale_colour_witcher_d}
\alias{scale_color_witcher_d}
\alias{scale_fill_witcher}
\alias{scale_fill_witcher_d}
\title{The Witcher colour scales}
\usage{
scale_color_witcher(
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  discrete = FALSE,
  option = "Geralt"
)

scale_colour_witcher(
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  discrete = FALSE,
  option = "Geralt"
)

scale_colour_witcher_d(
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  option = "Geralt",
  aesthetics = "colour"
)

scale_color_witcher_d(
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  option = "Geralt",
  aesthetics = "colour"
)

scale_fill_witcher(
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  discrete = FALSE,
  option = "Geralt"
)

scale_fill_witcher_d(
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  option = "Geralt",
  aesthetics = "fill"
)
}
\arguments{
\item{...}{parameters to \code{discrete_scale} or \code{scale_fill_gradientn}}

\item{alpha}{pass through parameter to \code{witcher}}

\item{begin}{The (corrected) hue in from 0 to 1 at which the witcher colormap begins.}

\item{end}{The (corrected) hue in from 0 to 1 at which the witcher colormap ends.}

\item{direction}{Sets the order of colors in the scale. If 1, the default, colors
are as output by \code{witcher_pal}. If -1, the order of colors is reversed.}

\item{discrete}{generate a discrete palette? (default: \code{FALSE} - generate continuous palette)}

\item{option}{A character string indicating the colourmap to use.}

\item{aesthetics}{Character string or vector of character strings listing the name(s) of the aesthetic(s) that this scale works with.
This can be useful, for example, to apply colour settings to the \code{colour} and \code{fill} aesthetics at the same time, via \code{aesthetics = c("colour", "fill")}.
Parameter inherited from 'ggplot2'.}
}
\description{
Uses the The Witcher color scale.
}
\details{
For \code{discrete == FALSE} (the default) all other arguments are as to
\link[ggplot2]{scale_fill_gradientn} or \link[ggplot2]{scale_color_gradientn}.
Otherwise the function will return a \code{discrete_scale} with the plot-computed
number of colors.
}
\examples{
library(ggplot2)
ggplot(data.frame(x = rnorm(10000), y = rnorm(10000)), aes(x = x, y = y)) +
geom_hex() + coord_fixed() +
scale_fill_witcher(option="ciri") + theme_bw()

ggplot(data.frame(x = rnorm(10000), y = rnorm(10000)), aes(x = x, y = y)) +
geom_hex() + coord_fixed() +
scale_fill_witcher(option="geralt") + theme_bw()


}
