% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce_dims.R
\name{reduce_dims}
\alias{reduce_dims}
\title{Project a feature matrix into a low dimensional representation using PCA or t-SNE}
\usage{
reduce_dims(
  data,
  method = c("z-score", "Sigmoid", "RobustSigmoid", "MinMax"),
  low_dim_method = c("PCA", "t-SNE"),
  perplexity = 30,
  seed = 123
)
}
\arguments{
\item{data}{the \code{feature_calculations} object containing the raw feature matrix produced by \code{calculate_features}}

\item{method}{a rescaling/normalising method to apply. Defaults to \code{"z-score"}}

\item{low_dim_method}{the low dimensional embedding method to use. Defaults to \code{"PCA"}}

\item{perplexity}{the perplexity hyperparameter to use if t-SNE algorithm is selected. Defaults to \code{30}}

\item{seed}{fixed number for R's random number generator to ensure reproducibility}
}
\value{
object of class \code{low_dimension}
}
\description{
Project a feature matrix into a low dimensional representation using PCA or t-SNE
}
\author{
Trent Henderson
}
