% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ts_correlations.R
\name{plot_ts_correlations}
\alias{plot_ts_correlations}
\title{Produce a correlation matrix plot showing pairwise correlations of time series with automatic hierarchical clustering}
\usage{
plot_ts_correlations(
  data,
  is_normalised = FALSE,
  id_var = "id",
  time_var = "timepoint",
  values_var = "values",
  method = c("z-score", "Sigmoid", "RobustSigmoid", "MinMax"),
  clust_method = c("average", "ward.D", "ward.D2", "single", "complete", "mcquitty",
    "median", "centroid"),
  cor_method = c("pearson", "spearman"),
  interactive = FALSE
)
}
\arguments{
\item{data}{a dataframewith at least 2 columns for \code{"id"} and \code{"values"} variables}

\item{is_normalised}{a Boolean as to whether the input feature values have already been scaled. Defaults to \code{FALSE}}

\item{id_var}{a string specifying the ID variable to compute pairwise correlations between. Defaults to \code{"id"}}

\item{time_var}{a string specifying the time index variable. Defaults to \code{NULL}}

\item{values_var}{a string denoting the name of the variable/column that holds the numerical feature values. Defaults to \code{"values"}}

\item{method}{a rescaling/normalising method to apply. Defaults to \code{"RobustSigmoid"}}

\item{clust_method}{the hierarchical clustering method to use for the pairwise correlation plot. Defaults to \code{"average"}}

\item{cor_method}{the correlation method to use. Defaults to \code{"pearson"}}

\item{interactive}{a Boolean as to whether to plot an interactive \code{plotly} graphic. Defaults to \code{FALSE}}
}
\value{
an object of class \code{ggplot}
}
\description{
Produce a correlation matrix plot showing pairwise correlations of time series with automatic hierarchical clustering
}
\examples{
plot_ts_correlations(data = simData, 
  is_normalised = FALSE, 
  id_var = "id", 
  time_var = "timepoint",
  values_var = "values",
  method = "RobustSigmoid",
  cor_method = "pearson",
  clust_method = "average",
  interactive = FALSE)

}
\author{
Trent Henderson
}
