% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc-functions.R
\name{mcmc_sample_halton_sequence}
\alias{mcmc_sample_halton_sequence}
\title{Returns a sample from the \code{dim} dimensional Halton sequence.}
\usage{
mcmc_sample_halton_sequence(dim, num_results = NULL,
  sequence_indices = NULL, dtype = tf$float32, randomized = TRUE,
  seed = NULL, name = NULL)
}
\arguments{
\item{dim}{Positive \code{integer} representing each sample's \code{event_size.} Must
not be greater than 1000.}

\item{num_results}{(Optional) Positive scalar \code{Tensor} of dtype int32. The number
of samples to generate. Either this parameter or sequence_indices must
be specified but not both. If this parameter is None, then the behaviour
is determined by the \code{sequence_indices}. Default value: \code{NULL}.}

\item{sequence_indices}{(Optional) \code{Tensor} of dtype int32 and rank 1. The
elements of the sequence to compute specified by their position in the
sequence. The entries index into the Halton sequence starting with 0 and
hence, must be whole numbers. For example, sequence_indices=\code{[0, 5, 6]} will
produce the first, sixth and seventh elements of the sequence. If this
parameter is None, then the \code{num_results} parameter must be specified
which gives the number of desired samples starting from the first sample.
Default value: \code{NULL}.}

\item{dtype}{(Optional) The dtype of the sample. One of: \code{float16}, \code{float32} or
\code{float64}. Default value: \code{tf$float32}.}

\item{randomized}{(Optional) bool indicating whether to produce a randomized
Halton sequence. If TRUE, applies the randomization described in
Owen (2017). Default value: \code{TRUE}.}

\item{seed}{(Optional) integer to seed the random number generator. Only
used if \code{randomized} is TRUE. If not supplied and \code{randomized} is TRUE,
no seed is set. Default value: \code{NULL}.}

\item{name}{(Optional) string describing ops managed by this function. If
not supplied the name of this function is used. Default value: "sample_halton_sequence".}
}
\value{
halton_elements Elements of the Halton sequence. \code{Tensor} of supplied dtype
and \code{shape} \code{[num_results, dim]} if \code{num_results} was specified or shape
\code{[s, dim]} where s is the size of \code{sequence_indices} if \code{sequence_indices}
were specified.
}
\description{
Warning: The sequence elements take values only between 0 and 1. Care must be
taken to appropriately transform the domain of a function if it differs from
the unit cube before evaluating integrals using Halton samples. It is also
important to remember that quasi-random numbers without randomization are not
a replacement for pseudo-random numbers in every context. Quasi random numbers
are completely deterministic and typically have significant negative
autocorrelation unless randomization is used.
}
\details{
Computes the members of the low discrepancy Halton sequence in dimension
\code{dim}. The \code{dim}-dimensional sequence takes values in the unit hypercube in
\code{dim} dimensions. Currently, only dimensions up to 1000 are supported. The
prime base for the k-th axes is the k-th prime starting from 2. For example,
if \code{dim} = 3, then the bases will be \code{[2, 3, 5]} respectively and the first
element of the non-randomized sequence will be: \code{[0.5, 0.333, 0.2]}. For a more
complete description of the Halton sequences see
\href{https://en.wikipedia.org/wiki/Halton_sequence}{here}. For low discrepancy
sequences and their applications see
\href{https://en.wikipedia.org/wiki/Low-discrepancy_sequence}{here}.

If \code{randomized} is true, this function produces a scrambled version of the
Halton sequence introduced by Owen (2017). For the advantages of
randomization of low discrepancy sequences see
\href{https://en.wikipedia.org/wiki/Quasi-Monte_Carlo_method#Randomization_of_quasi-Monte_Carlo}{here}.

The number of samples produced is controlled by the \code{num_results} and
\code{sequence_indices} parameters. The user must supply either \code{num_results} or
\code{sequence_indices} but not both.
The former is the number of samples to produce starting from the first
element. If \code{sequence_indices} is given instead, the specified elements of
the sequence are generated. For example, sequence_indices=tf$range(10) is
equivalent to specifying n=10.
}
\section{References}{

\itemize{
\item \href{https://arxiv.org/abs/1706.02808}{Art B. Owen. A randomized Halton algorithm in R. arXiv preprint arXiv:1706.02808, 2017.}
}
}

\seealso{
For an example how to use see \code{\link[=mcmc_sample_chain]{mcmc_sample_chain()}}.

Other mcmc_functions: \code{\link{mcmc_effective_sample_size}},
  \code{\link{mcmc_potential_scale_reduction}},
  \code{\link{mcmc_sample_annealed_importance_chain}},
  \code{\link{mcmc_sample_chain}}
}
\concept{mcmc_functions}
