% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts-functions.R
\name{sts_decompose_forecast_by_component}
\alias{sts_decompose_forecast_by_component}
\title{Decompose a forecast distribution into contributions from each component.}
\usage{
sts_decompose_forecast_by_component(model, forecast_dist, parameter_samples)
}
\arguments{
\item{model}{An instance of \code{sts_sum} representing a structural time series model.}

\item{forecast_dist}{A \code{Distribution} instance returned by \code{sts_forecast()}.
(specifically, must be a \code{tfd.MixtureSameFamily} over a
\code{tfd_linear_gaussian_state_space_model} parameterized by posterior samples).}

\item{parameter_samples}{\code{list} of \code{tensors} representing posterior samples
of model parameters, with shapes
\verb{list(tf$concat(list(list(num_posterior_draws), param<1>$prior$batch_shape, param<1>$prior$event_shape), list(list(num_posterior_draws), param<2>$prior$batch_shape, param<2>$prior$event_shape), ... ) )}
for all model parameters.
This may optionally also be a named list mapping parameter names to \code{tensor} values.}
}
\value{
component_dists A named list mapping
component StructuralTimeSeries instances (elements of \code{model$components})
to \code{Distribution} instances representing the marginal forecast for each component.
Each distribution has batch shape matching \code{forecast_dist} (specifically,
the event shape is \verb{[num_steps_forecast]}).
}
\description{
Decompose a forecast distribution into contributions from each component.
}
\seealso{
Other sts-functions: 
\code{\link{sts_build_factored_surrogate_posterior}()},
\code{\link{sts_build_factored_variational_loss}()},
\code{\link{sts_decompose_by_component}()},
\code{\link{sts_fit_with_hmc}()},
\code{\link{sts_forecast}()},
\code{\link{sts_one_step_predictive}()},
\code{\link{sts_sample_uniform_initial_state}()}
}
\concept{sts-functions}
