% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution-layers.R
\name{layer_distribution_lambda}
\alias{layer_distribution_lambda}
\title{Keras layer enabling plumbing TFP distributions through Keras models}
\usage{
layer_distribution_lambda(
  object,
  make_distribution_fn,
  convert_to_tensor_fn = tfp$distributions$Distribution$sample,
  ...
)
}
\arguments{
\item{object}{Model or layer object}

\item{make_distribution_fn}{A callable that takes previous layer outputs and returns a \code{tfd$distributions$Distribution} instance.}

\item{convert_to_tensor_fn}{A callable that takes a tfd$Distribution instance and returns a
tf$Tensor-like object. Default value: \code{tfd$distributions$Distribution$sample}.}

\item{...}{Additional arguments passed to \code{args} of \code{keras::create_layer}.}
}
\value{
a Keras layer
}
\description{
Keras layer enabling plumbing TFP distributions through Keras models
}
\seealso{
For an example how to use in a Keras model, see \code{\link[=layer_independent_normal]{layer_independent_normal()}}.

Other distribution_layers: 
\code{\link{layer_categorical_mixture_of_one_hot_categorical}()},
\code{\link{layer_independent_bernoulli}()},
\code{\link{layer_independent_logistic}()},
\code{\link{layer_independent_normal}()},
\code{\link{layer_independent_poisson}()},
\code{\link{layer_kl_divergence_add_loss}()},
\code{\link{layer_kl_divergence_regularizer}()},
\code{\link{layer_mixture_logistic}()},
\code{\link{layer_mixture_normal}()},
\code{\link{layer_mixture_same_family}()},
\code{\link{layer_multivariate_normal_tri_l}()},
\code{\link{layer_one_hot_categorical}()}
}
\concept{distribution_layers}
