% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{plot.tf}
\alias{plot.tf}
\alias{lines.tf}
\alias{points.tf}
\title{\code{base} plots for \code{tf}s}
\usage{
\method{plot}{tf}(
  x,
  y,
  n_grid = 50,
  points = is_irreg(x),
  type = c("spaghetti", "lasagna"),
  alpha = min(1, max(0.05, 2/length(x))),
  ...
)

\method{lines}{tf}(x, arg, n_grid = 50, alpha = min(1, max(0.05, 2/length(x))), ...)

\method{points}{tf}(
  x,
  arg,
  n_grid = NA,
  alpha = min(1, max(0.05, 2/length(x))),
  interpolate = FALSE,
  ...
)
}
\arguments{
\item{x}{an \code{tf} object}

\item{y}{(optional) numeric vector to be used as \code{arg}
(i.e., for the \strong{x}-axis...!)}

\item{n_grid}{minimal size of equidistant grid used for plotting,
defaults to 50. See details.}

\item{points}{should the original evaluation points be marked by points?
Defaults to \code{TRUE} for irregular \code{tfd} and FALSE for all others}

\item{type}{"spaghetti": line plots, "lasagna": heat maps.}

\item{alpha}{alpha-value (see\code{\link[grDevices:rgb]{grDevices::rgb()}}) for noodle transparency.
Defaults to 2/(no. of observations). Lower is more transparent.}

\item{...}{additional arguments for \code{\link[=matplot]{matplot()}} ("spaghetti") or
\code{\link[=image]{image()}} ("lasagna")}

\item{arg}{evaluation grid (vector)}

\item{interpolate}{should functions be evaluated (i.e., inter-/extrapolated)
for arg for which no original data is available? Only relevant for
tfd, defaults to FALSE}
}
\value{
the plotted \code{tf}-object, invisibly.
}
\description{
Some \code{base} functions for displaying functional data in
spaghetti- (i.e., line plots) and lasagna- (i.e., heat map) flavors.
}
\details{
If no second argument \code{y} is given, evaluation points (\code{arg}) for the functions
are given by the union of the \code{tf}'s \code{arg} and an equidistant grid
over its domain with \code{n_grid} points. If you want to only see the original
data for \code{tfd}-objects without inter-/extrapolation, use \code{n_grid < 1} or
\code{n_grid = NA}.
}
\references{
Swihart, J B, Caffo, Brian, James, D B, Strand, Matthew, Schwartz, S B, Punjabi, M N (2010).
\dQuote{Lasagna plots: a saucy alternative to spaghetti plots.}
\emph{Epidemiology (Cambridge, Mass.)}, \bold{21}(5), 621--625.
}
\concept{tidyfun visualization}
