% Generated by roxygen2 (4.0.2): do not edit by hand
\name{textreg}
\alias{textreg}
\title{Sparse regression of labeling vector onto all phrases in a corpus.}
\usage{
textreg(corpus, labeling, banned = NULL, objective.function = 2, C = 1,
  a = 1, maxIter = 40, verbosity = 1, step.verbosity = verbosity,
  positive.only = FALSE, binary.features = FALSE, positive.weight = 1,
  Lq = 2, min.support = 1, min.pattern = 1, max.pattern = 100,
  gap = 0, token.type = "word", convergence.threshold = 1e-04)
}
\arguments{
\item{corpus}{A list of strings or a corpus from the \code{tm} package.}

\item{labeling}{A vector of +1/-1 or TRUE/FALSE indicating which documents are considered relevant and
which are baseline.  The +1/-1 can contain 0 whcih means drop the document.}

\item{banned}{List of words that should be dropped from consideration.}

\item{objective.function}{2 is hinge loss.  0 is something.  1 is something else.}

\item{C}{The regularization term.  0 is no regularization.}

\item{a}{What percent of regularization should be L1 loss (a=1) vs L2 loss (a=0)}

\item{maxIter}{Number of gradient descent steps to take (not including intercept adjustments)}

\item{verbosity}{Level of output.  0 is no printed output.}

\item{step.verbosity}{Level of output for line searches.  0 is no printed output.}

\item{positive.only}{Disallow negative features if true}

\item{binary.features}{Just code presence/absence of a feature in a document rather than count of feature in document.}

\item{positive.weight}{Scale weight pf all positively marked documents by this value.  (1, i.e., no scaling) is default)   NOT FULLY IMPLEMENTED}

\item{Lq}{Rescaling to put on the features (2 is standard).  Can be from 1 up.  Values above 10 invoke an infinity-norm.}

\item{min.support}{Only consider phrases that appear this many times or more.}

\item{min.pattern}{Only consider phrases this long or longer}

\item{max.pattern}{Only consider phrases this short or shorter}

\item{gap}{Allow phrases that have wildcard words in them.  Number is how many wildcards in a row.}

\item{token.type}{"word" or "character" as tokens.}

\item{convergence.threshold}{How to decide if descent has converged.  (Will go for three steps at this threshold to check for flatness.)}
}
\value{
A \code{\link{textreg.result}} object.
}
\description{
Given a labeling and a corpus, find phrases that predict this labeling.  This function
calls a C++ function that builds a tree of phrases and searches it using greedy coordinate
descent to solve the optimization problem associated with the associated sparse regression.
}
\details{
See the bathtub vignette for more complete discussion of this method and the options
you might pass to it.
}
\examples{
data( testCorpora )
textreg( testCorpora$testI$corpus, testCorpora$testI$labelI, c(), C=1, verbosity=1 )
}

