% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_normalization.R
\name{step_text_normalization}
\alias{step_text_normalization}
\alias{tidy.step_text_normalization}
\title{Normalization of \link{tokenlist} variables}
\usage{
step_text_normalization(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  columns = NULL,
  normalization_form = "nfc",
  skip = FALSE,
  id = rand_id("text_normalization")
)

\method{tidy}{step_text_normalization}(x, ...)
}
\arguments{
\item{recipe}{A \link{recipe} object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are affected by the step. See \code{\link[recipes:selections]{recipes::selections()}}
for more details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A character string of variable names that will
be populated (eventually) by the \code{terms} argument. This is \code{NULL}
until the step is trained by \code{\link[recipes:prep]{recipes::prep.recipe()}}.}

\item{normalization_form}{A single character string determining the Unicode
Normalization. Must be one of "nfc", "nfd", "nfkd", "nfkc", or
"nfkc_casefold". Defaults to "nfc".
See \code{\link[stringi:stri_trans_nf]{stringi::stri_trans_nfc()}} for more details.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{recipes::bake.recipe()}}? While all operations are baked
when \code{\link[recipes:prep]{recipes::prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = FALSE}.}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_text_normalization} object.}
}
\value{
An updated version of \code{recipe} with the new step added
to the sequence of existing steps (if any).
}
\description{
\code{step_text_normalization} creates a \emph{specification} of a recipe step that
will perform Unicode Normalization
}
\examples{
if (requireNamespace("stringi", quietly = TRUE)) {
  library(recipes)

  sample_data <- tibble(text = c("sch\U00f6n", "scho\U0308n"))

  rec <- recipe(~., data = sample_data) \%>\%
    step_text_normalization(text)

  prepped <- rec \%>\%
    prep()

  bake(prepped, new_data = NULL, text) \%>\%
    slice(1:2)

  bake(prepped, new_data = NULL) \%>\%
    slice(2) \%>\%
    pull(text)

  tidy(rec, number = 1)
  tidy(prepped, number = 1)
}

}
\seealso{
\code{\link[=step_texthash]{step_texthash()}} for feature hashing.
}
\concept{character to character steps}
