% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/un_zip.R
\name{un_zip}
\alias{un_zip}
\alias{un_tar}
\title{Unzip/Unzip Files}
\usage{
un_zip(file, loc = dirname(file), ...)

un_tar(file, loc = dirname(file), ...)
}
\arguments{
\item{file}{Path to the zip file.}

\item{loc}{The output directory location.}

\item{...}{Other arguments passed to \code{\link[utils:unzip]{utils::unzip()}}.}
}
\value{
Returns the path to where the zip file was unzipped to.
}
\description{
Unzip/untar files and return the location of exit directory.  This is a convenience
function (wrapper for \code{\link[utils:unzip]{utils::unzip()}}) to make the function more
pipe-able.  Additionally, the location of the unzip defaults to the directory
containing the zip file.
}
\examples{
\dontrun{
if (!require("pacman")) install.packages("pacman")
pacman::p_load(tidyverse)

dl_loc <- 'http://www.cs.uic.edu/~liub/FBS/CustomerReviewData.zip'  \%>\%
    download() \%>\%
    un_zip()


dir(dl_loc, pattern = '[Cc]ustomer')
dir(dl_loc, pattern = 'customer', full.names = TRUE)[1] \%>\%
    dir()

dir(dl_loc, pattern = 'customer', full.names = TRUE)[1] \%>\%
    dir(pattern = '\\\\.txt$', full.names = TRUE) 

dir(dl_loc, pattern = 'customer', full.names = TRUE)[1] \%>\%
    read_dir()


dir(dl_loc, pattern = 'customer', full.names = TRUE)[1] \%>\%
    dir(pattern = '\\\\.txt$', full.names = TRUE) \%>\%
    `[`(1) \%>\%
    read_document()
}
}
\seealso{
\code{\link[utils:unzip]{utils::unzip()}}
}
\keyword{unzip}
