% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dtm2Tcm.R
\name{Dtm2Tcm}
\alias{Dtm2Tcm}
\title{Turn a document term matrix into a term co-occurence matrix}
\usage{
Dtm2Tcm(dtm)
}
\arguments{
\item{dtm}{A document term matrix, generally of class \code{dgCMatrix}, though
other classes, such as \code{dgTMatrix}, may also work without issue.}
}
\value{
Returns a square \code{dgCMatrix} whose rows and columns both index
terms. The i, j entries of this matrix represent the count of term j across
documents containing term i. Note that, while square, this matrix is not
symmetric.
}
\description{
Turn a document term matrix, whose rows index documents and 
whose columns index terms, into a term co-occurence matrix. A term co-occurence
matrix's rows and columns both index terms. See \code{details}, below.
}
\examples{
data(nih_sample_dtm)

tcm <- Dtm2Tcm(nih_sample_dtm)
}

