% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-embedding.R
\name{find_projection}
\alias{find_projection}
\title{Find the 'projection matrix' to a semantic vector}
\usage{
find_projection(wv, vec)
}
\arguments{
\item{wv}{Matrix of word embedding vectors (a.k.a embedding model)
with rows as words.}

\item{vec}{Vector extracted from the embeddings}
}
\value{
A new word embedding matrix,
each row of which is parallel to vector.
}
\description{
"Project" each word in a word embedding matrix of \eqn{D} dimension along a
vector of \eqn{D} dimensions, extracted from the same embedding space.
The vector can be a single word, or a concept vector obtained from
\code{get_centroid()}, \code{get_direction()}, or \code{get_regions()}.
}
\details{
All the vectors in the matrix \eqn{A} are projected onto the a vector,
\eqn{v}, to find the projection matrix, \eqn{P}, defined as:
\deqn{P = \frac{A \cdot v}{v \cdot v} * v}
}
